/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class KunststoffButtonUI
extends MetalButtonUI {
    private static final KunststoffButtonUI buttonUI = new KunststoffButtonUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (!jComponent.isOpaque()) {
            return;
        }
        Container container = jComponent.getParent();
        if (container instanceof JToolBar) {
            int n = ((JToolBar)container).getOrientation();
            Point point = jComponent.getLocation();
            ColorUIResource colorUIResource = KunststoffLookAndFeel.getComponentGradientColorReflection();
            ColorUIResource colorUIResource2 = KunststoffLookAndFeel.getComponentGradientColorShadow();
            if (n == 0) {
                Color color;
                if (colorUIResource != null) {
                    color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
                    Rectangle rectangle = new Rectangle(0, -point.y, container.getWidth(), container.getHeight() / 2);
                    KunststoffUtilities.drawGradient(graphics, colorUIResource, color, rectangle, true);
                }
                if (colorUIResource2 != null) {
                    color = KunststoffUtilities.getTranslucentColor(colorUIResource2, 0);
                    Rectangle rectangle = new Rectangle(0, container.getHeight() / 2 - point.y, container.getWidth(), container.getHeight() / 2);
                    KunststoffUtilities.drawGradient(graphics, color, colorUIResource2, rectangle, true);
                }
            } else {
                Color color;
                if (colorUIResource != null) {
                    color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
                    Rectangle rectangle = new Rectangle(0, 0, container.getWidth() / 2, container.getHeight());
                    KunststoffUtilities.drawGradient(graphics, colorUIResource, color, rectangle, false);
                }
                if (colorUIResource2 != null) {
                    color = KunststoffUtilities.getTranslucentColor(colorUIResource2, 0);
                    Rectangle rectangle = new Rectangle(container.getWidth() / 2 - point.x, 0, container.getWidth(), container.getHeight());
                    KunststoffUtilities.drawGradient(graphics, color, colorUIResource2, rectangle, false);
                }
            }
        } else {
            Serializable serializable;
            Color color;
            ColorUIResource colorUIResource = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorUIResource != null) {
                color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
                serializable = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight() / 2);
                KunststoffUtilities.drawGradient(graphics, colorUIResource, color, (Rectangle)serializable, true);
            }
            if ((color = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                serializable = KunststoffUtilities.getTranslucentColor(color, 0);
                Rectangle rectangle = new Rectangle(0, jComponent.getHeight() / 2, jComponent.getWidth(), jComponent.getHeight() / 2);
                KunststoffUtilities.drawGradient(graphics, serializable, color, rectangle, true);
            }
        }
    }
}

