/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.datacontrol;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.factset.FactSetDefinition;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.StringPClassUtil;

public class FactSetDefToken
extends AbstractTokenWithSeparator<FactSetDefinition>
implements CDOMPrimaryToken<FactSetDefinition> {
    public String getTokenName() {
        return "FACTSETDEF";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, FactSetDefinition def, String value) {
        Class cl;
        StringTokenizer aTok = new StringTokenizer(value, "|");
        String fileType = aTok.nextToken();
        if (!aTok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " expects 2 PIPE separated values, found 1 in: " + value, context);
        }
        String identifier = aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " expects 3 PIPE separated values, found too many in: " + value, context);
        }
        if ("GLOBAL".equals(fileType)) {
            cl = CDOMObject.class;
        } else {
            cl = StringPClassUtil.getClassFor((String)fileType);
            if (cl == null) {
                throw new IllegalArgumentException("Invalid Data Definition Location (no class): " + fileType);
            }
        }
        def.setUsableLocation(cl);
        def.setFactSetName(identifier);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, FactSetDefinition def) {
        Class cl = def.getUsableLocation();
        String name = def.getFactSetName();
        if (cl == null) {
            if (name == null) {
                return null;
            }
            context.addWriteMessage("Found FactDefinition with location but no name");
            return null;
        }
        if (name == null) {
            context.addWriteMessage("Found FactDefinition with name but no location");
            return null;
        }
        return new String[]{StringPClassUtil.getStringFor((Class)cl) + "|" + name};
    }

    public Class<FactSetDefinition> getTokenClass() {
        return FactSetDefinition.class;
    }
}

