/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass.level;

import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CastToken
extends AbstractTokenWithSeparator<PCClassLevel>
implements CDOMPrimaryToken<PCClassLevel> {
    public String getTokenName() {
        return "CAST";
    }

    protected char separator() {
        return ',';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClassLevel level, String value) {
        context.getObjectContext().removeList((CDOMObject)level, ListKey.CAST);
        ParsingSeparator sep = new ParsingSeparator(value, ',');
        while (sep.hasNext()) {
            String tok = sep.next();
            try {
                if (Integer.parseInt(tok) < 0) {
                    return new ParseResult.Fail("Invalid Spell Count: " + tok + " is less than zero", context);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Formula formula = FormulaFactory.getFormulaFor((String)tok);
            if (!formula.isValid()) {
                return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + formula.toString(), context);
            }
            context.getObjectContext().addToList((CDOMObject)level, ListKey.CAST, (Object)formula);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClassLevel level) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)level, ListKey.CAST);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join((Collection)changes.getAdded(), (String)",")};
    }

    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }
}

