/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.AbstractPrerequisiteTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.core.utils.CoreUtility;

public class PreVariableTester
extends AbstractPrerequisiteTest
implements PrerequisiteTest {
    public String kindHandled() {
        return "VAR";
    }

    public int passes(Prerequisite prereq, Equipment equipment, PlayerCharacter aPC) throws PrerequisiteException {
        if (aPC == null) {
            return 0;
        }
        String eqVar = "EQ:" + equipment.getNonHeadedName();
        float aVar = equipment.getVariableValue(prereq.getKey(), eqVar, aPC).floatValue();
        float aTarget = equipment.getVariableValue(prereq.getOperand(), eqVar, aPC).floatValue();
        float runningTotal = prereq.getOperator().compare(aVar, aTarget);
        if (CoreUtility.doublesEqual((double)runningTotal, (double)0.0)) {
            return 0;
        }
        for (Prerequisite element : prereq.getPrerequisites()) {
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null || !CoreUtility.doublesEqual((double)(runningTotal = (float)test.passes(element, equipment, aPC)), (double)0.0)) continue;
            return 0;
        }
        return this.countedTotal(prereq, 1);
    }

    public int passes(Prerequisite prereq, PlayerCharacter character, CDOMObject source) throws PrerequisiteException {
        String src = source == null ? "" : source.getQualifiedKey();
        float aVar = character.getVariableValue(prereq.getKey(), src).floatValue();
        float aTarget = character.getVariableValue(prereq.getOperand(), src).floatValue();
        float runningTotal = prereq.getOperator().compare(aVar, aTarget);
        if (CoreUtility.doublesEqual((double)runningTotal, (double)0.0)) {
            return 0;
        }
        for (Prerequisite element : prereq.getPrerequisites()) {
            PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
            PrerequisiteTest test = factory.getTest(element.getKind());
            if (test == null || !CoreUtility.doublesEqual((double)(runningTotal = (float)test.passes(element, character, source)), (double)0.0)) continue;
            return 0;
        }
        return this.countedTotal(prereq, 1);
    }
}

