/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.PCClass;
import pcgen.core.SizeAdjustment;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class UdamLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject>,
DeferredToken<CDOMObject> {
    public String getTokenName() {
        return "UDAM";
    }

    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        ParseResult.Pass pr = ParseResult.SUCCESS;
        if (".CLEAR".equals(value)) {
            if (obj instanceof PCClassLevel || obj instanceof PCClass) {
                PCClass pcc = obj instanceof PCClassLevel ? (PCClass)obj.get(ObjectKey.TOKEN_PARENT) : (PCClass)obj;
                context.getObjectContext().removeList((CDOMObject)pcc, ListKey.UNARMED_DAMAGE);
                for (PCClassLevel level : pcc.getOriginalClassLevelCollection()) {
                    context.getObjectContext().removeList((CDOMObject)level, ListKey.UNARMED_DAMAGE);
                }
            } else {
                context.getObjectContext().removeList(obj, ListKey.UNARMED_DAMAGE);
            }
        } else {
            pr = this.checkForIllegalSeparator(',', value);
            if (!pr.passed()) {
                return pr;
            }
            StringTokenizer tok = new StringTokenizer(value, ",");
            if (context.getObjectContext().containsListFor(obj, ListKey.UNARMED_DAMAGE)) {
                ComplexParseResult cpr = new ComplexParseResult();
                cpr.addWarningMessage(obj.getDisplayName() + " already has " + this.getTokenName() + " set.");
                cpr.addWarningMessage(" It will be redefined, but you should be using " + this.getTokenName() + ":.CLEAR");
                pr = cpr;
                context.getObjectContext().removeList(obj, ListKey.UNARMED_DAMAGE);
            }
            while (tok.hasMoreTokens()) {
                context.getObjectContext().addToList(obj, ListKey.UNARMED_DAMAGE, (Object)tok.nextToken());
            }
        }
        return pr;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Collection list;
        Changes changes = context.getObjectContext().getListChanges(obj, ListKey.UNARMED_DAMAGE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>(2);
        if (changes.includesGlobalClear()) {
            returnList.add(".CLEAR");
        }
        if ((list = changes.getAdded()) != null) {
            returnList.add(StringUtil.join((Collection)list, (String)","));
        }
        if (returnList.isEmpty()) {
            return null;
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public boolean process(LoadContext context, CDOMObject obj) {
        List changes = obj.getListFor(ListKey.UNARMED_DAMAGE);
        if (changes == null) {
            return true;
        }
        int gameModeSizeCount = context.getReferenceContext().getConstructedObjectCount(SizeAdjustment.class);
        if (changes.size() != gameModeSizeCount && changes.size() != 1) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Unarmed Damage " + StringUtil.join((Collection)changes, (String)", ") + " had " + changes.size() + " entries, but must be 1 or " + gameModeSizeCount));
            return false;
        }
        return true;
    }

    public Class<CDOMObject> getDeferredTokenClass() {
        return CDOMObject.class;
    }
}

