/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.companionmod;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.core.PCClass;
import pcgen.core.SubClass;
import pcgen.core.character.CompanionMod;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class FollowerToken
extends AbstractTokenWithSeparator<CompanionMod>
implements CDOMPrimaryToken<CompanionMod> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<SubClass> SUBCLASS_CLASS = SubClass.class;

    public String getTokenName() {
        return "FOLLOWER";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CompanionMod cMod, String value) {
        int equalLoc = value.indexOf(61);
        if (equalLoc == -1) {
            return new ParseResult.Fail("No = in token.", context);
        }
        if (equalLoc != value.lastIndexOf(61)) {
            return new ParseResult.Fail("Too many = in token.", context);
        }
        String classString = value.substring(0, equalLoc);
        String levelString = value.substring(equalLoc + 1);
        Integer lvl = Integer.valueOf(levelString);
        context.getObjectContext().put((CDOMObject)cMod, IntegerKey.LEVEL, lvl);
        StringTokenizer bTok = new StringTokenizer(classString, ",");
        while (bTok.hasMoreTokens()) {
            String classKey = bTok.nextToken();
            PCClass pcClass = (PCClass)context.getReferenceContext().silentlyGetConstructedCDOMObject(PCCLASS_CLASS, classKey);
            if (pcClass != null) {
                CDOMSingleRef pcc = context.getReferenceContext().getCDOMReference(PCCLASS_CLASS, classKey);
                context.getObjectContext().put((CDOMObject)cMod, MapKey.APPLIED_CLASS, (Object)pcc, (Object)lvl);
                continue;
            }
            context.getObjectContext().put((CDOMObject)cMod, MapKey.APPLIED_VARIABLE, (Object)classKey, (Object)lvl);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CompanionMod cMod) {
        MapChanges changes = context.getObjectContext().getMapChanges((CDOMObject)cMod, MapKey.APPLIED_CLASS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        Map map = changes.getAdded();
        for (Map.Entry me : map.entrySet()) {
            CDOMSingleRef ref = (CDOMSingleRef)me.getKey();
            Class refClass = ref.getReferenceClass();
            if (SUBCLASS_CLASS.equals(refClass)) {
                Category parent = ((CategorizedCDOMReference)ref).getCDOMCategory();
                set.add(parent.toString() + "." + ref.getLSTformat(false) + '=' + me.getValue());
                continue;
            }
            set.add(ref.getLSTformat(false) + '=' + me.getValue());
        }
        return new String[]{StringUtil.join(set, (String)"|")};
    }

    public Class<CompanionMod> getTokenClass() {
        return CompanionMod.class;
    }
}

