/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class PreAlignTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, Equipment equipment, CharacterDisplay display) throws PrerequisiteException {
        if (display == null) {
            return 0;
        }
        return this.passes(prereq, display, (CDOMObject)equipment);
    }

    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int runningTotal = 0;
        if (Globals.getGameModeAlignmentText().length() == 0) {
            runningTotal = 1;
        } else {
            String desiredAlignment = prereq.getKey();
            PCAlignment charAlignment = display.getPCAlignment();
            if (prereq.getOperator().equals((Object)PrerequisiteOperator.EQ)) {
                if (this.alignMatches(display, desiredAlignment, charAlignment)) {
                    ++runningTotal;
                }
            } else if (prereq.getOperator().equals((Object)PrerequisiteOperator.NEQ)) {
                if (!this.alignMatches(display, desiredAlignment, charAlignment)) {
                    ++runningTotal;
                }
            } else {
                throw new PrerequisiteException(LanguageBundle.getFormattedString("PreAlign.error.invalidComparison", prereq.getOperator().toString(), prereq.toString()));
            }
        }
        return this.countedTotal(prereq, runningTotal);
    }

    private boolean alignMatches(CharacterDisplay display, String desiredAlignment, PCAlignment charAlignment) {
        CDOMSingleRef<PCAlignment> deityAlign;
        PCAlignment al = this.getPCAlignment(desiredAlignment);
        if (al.equals(charAlignment)) {
            return true;
        }
        return desiredAlignment.equalsIgnoreCase("Deity") && display.getDeity() != null && (deityAlign = display.getDeity().get(ObjectKey.ALIGNMENT)) != null && charAlignment.equals(deityAlign.resolvesTo());
    }

    @Override
    public String kindHandled() {
        return "align";
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        String alignment = prereq.getKey();
        PCAlignment al = this.getPCAlignment(alignment);
        return LanguageBundle.getFormattedString("PreAlign.toHtml", prereq.getOperator().toDisplayString(), al.getKeyName());
    }

    private PCAlignment getPCAlignment(String desiredAlignIdentifier) {
        PCAlignment desiredAlign = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCAlignment.class, desiredAlignIdentifier);
        if (desiredAlign == null) {
            Logging.errorPrint("Unable to find alignment that matches: " + desiredAlignIdentifier);
        }
        return desiredAlign;
    }
}

