/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.core.PCTemplate;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RacesubtypeToken
extends AbstractTokenWithSeparator<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    @Override
    public String getTokenName() {
        return "RACESUBTYPE";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCTemplate template, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String aType = tok.nextToken();
            if (aType.startsWith(".REMOVE.")) {
                String substring = aType.substring(8);
                if (substring.length() == 0) {
                    return new ParseResult.Fail("Invalid .REMOVE. in " + this.getTokenName() + " requires an argument", context);
                }
                context.getObjectContext().addToList(template, ListKey.REMOVED_RACESUBTYPE, RaceSubType.getConstant(substring));
                continue;
            }
            context.getObjectContext().addToList(template, ListKey.RACESUBTYPE, RaceSubType.getConstant(aType));
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCTemplate pct) {
        Changes<RaceSubType> addedChanges = context.getObjectContext().getListChanges(pct, ListKey.RACESUBTYPE);
        Changes<RaceSubType> removedChanges = context.getObjectContext().getListChanges(pct, ListKey.REMOVED_RACESUBTYPE);
        Collection<RaceSubType> added = addedChanges.getAdded();
        Collection<RaceSubType> removed = removedChanges.getAdded();
        if (added == null && removed == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean needPipe = false;
        if (removed != null) {
            for (RaceSubType rst : removed) {
                if (needPipe) {
                    sb.append("|");
                }
                sb.append(".REMOVE.").append(rst.toString());
                needPipe = true;
            }
        }
        if (added != null) {
            for (RaceSubType rst : added) {
                if (needPipe) {
                    sb.append("|");
                }
                sb.append(rst.toString());
                needPipe = true;
            }
        }
        return new String[]{sb.toString()};
    }

    @Override
    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

