/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MonnonskillhdToken
extends AbstractNonEmptyToken<PCClass>
implements CDOMPrimaryToken<PCClass> {
    @Override
    public String getTokenName() {
        return "MONNONSKILLHD";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, PCClass pcc, String value) {
        BonusObj bon = Bonus.newBonus(context, "MONNONSKILLHD|NUMBER|" + value);
        if (bon == null) {
            return new ParseResult.Fail(this.getTokenName() + " was given invalid bonus value: " + value, context);
        }
        bon.setTokenSource(this.getTokenName());
        context.getObjectContext().addToList(pcc, ListKey.BONUS, bon);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass obj) {
        Changes<BonusObj> changes = context.getObjectContext().getListChanges(obj, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<BonusObj> added = changes.getAdded();
        String tokenName = this.getTokenName();
        TreeSet<String> bonusSet = new TreeSet<String>();
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(bonus.getValue());
            if (bonus.hasPrerequisites()) {
                sb.append('|');
                sb.append(this.getPrerequisiteString(context, bonus.getPrerequisiteList()));
            }
            bonusSet.add(sb.toString());
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

