/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.levelability;

import java.util.StringTokenizer;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.core.kit.KitLevelAbility;
import pcgen.io.Compatibility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AbilityToken
extends AbstractToken
implements CDOMPrimaryToken<KitLevelAbility> {
    @Override
    public String getTokenName() {
        return "ABILITY";
    }

    @Override
    public Class<KitLevelAbility> getTokenClass() {
        return KitLevelAbility.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, KitLevelAbility kitAbility, String value) {
        PersistentTransitionChoice<?> ptc;
        if (!value.startsWith("PROMPT:")) {
            return new ParseResult.Fail("Expected " + this.getTokenName() + " to start with PROMPT: " + value, context);
        }
        StringTokenizer st = new StringTokenizer(value, "|");
        String first = st.nextToken();
        try {
            ptc = Compatibility.processOldAdd(context, first);
        }
        catch (PersistenceLayerException e) {
            return new ParseResult.Fail(e.getMessage(), context);
        }
        if (ptc == null) {
            return new ParseResult.Fail("Error was in " + this.getTokenName() + " " + value, context);
        }
        kitAbility.setAdd(ptc);
        while (st.hasMoreTokens()) {
            String choiceString = st.nextToken();
            if (!choiceString.startsWith("CHOICE:")) {
                return new ParseResult.Fail("Expected " + this.getTokenName() + " choice string to start with CHOICE: " + value, context);
            }
            String choice = choiceString.substring(7);
            if (first.equals("FEAT") && !choice.startsWith("CATEGORY=")) {
                choice = "CATEGORY=FEAT|" + choice;
            }
            if (ptc.decodeChoice(context, choice) == null) {
                return new ParseResult.Fail(choiceString + " is not a valid selection for ADD:" + first, context);
            }
            kitAbility.addChoice(choice);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitLevelAbility kitAbility) {
        return new String[]{"PROMPT:"};
    }
}

