/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.datacontrol;

import pcgen.cdom.content.ContentDefinition;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RequiredToken
extends AbstractNonEmptyToken<ContentDefinition>
implements CDOMPrimaryToken<ContentDefinition> {
    @Override
    public String getTokenName() {
        return "REQUIRED";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, ContentDefinition factDef, String value) {
        boolean set;
        char firstChar = value.charAt(0);
        if (firstChar == 'y' || firstChar == 'Y') {
            if (value.length() > 1 && !value.equalsIgnoreCase("YES")) {
                return new ParseResult.Fail("You should use 'YES' as the " + this.getTokenName() + ": " + value, context);
            }
            set = true;
        } else {
            if (firstChar != 'N' && firstChar != 'n') {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            if (value.length() > 1 && !value.equalsIgnoreCase("NO")) {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            set = false;
        }
        factDef.setRequired(set);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, ContentDefinition factDef) {
        Boolean required = factDef.getRequired();
        if (required == null) {
            return null;
        }
        return new String[]{required != false ? "YES" : "NO"};
    }

    @Override
    public Class<ContentDefinition> getTokenClass() {
        return ContentDefinition.class;
    }
}

