/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SpellListToken;

public class SpellListCastToken
extends SpellListToken {
    public static final String TOKENNAME = "SPELLLISTCAST";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringBuilder retValue = new StringBuilder();
        SpellListToken.SpellListTokenParams params = new SpellListToken.SpellListTokenParams(tokenSource, 0);
        PObject aObject = pc.getSpellClassAtIndex(params.getClassNum());
        if (aObject != null) {
            retValue.append(this.getCastNum(aObject, params.getLevel(), pc));
        }
        return retValue.toString();
    }

    private String getCastNum(CDOMObject aObject, int level, PlayerCharacter pc) {
        String castNum = "--";
        if (aObject instanceof PCClass) {
            PCClass aClass = (PCClass)aObject;
            castNum = String.valueOf(pc.getSpellSupport(aClass).getCastForLevel(level, Globals.getDefaultSpellBook(), true, false, pc)) + pc.getSpellSupport(aClass).getBonusCastForLevelString(level, Globals.getDefaultSpellBook(), pc);
        }
        return castNum;
    }
}

