/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.Follower;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.FileAccess;
import pcgen.io.exporttoken.AbstractExportToken;

public class FollowerListToken
extends AbstractExportToken {
    @Override
    public String getTokenName() {
        return "FOLLOWERLIST";
    }

    @Override
    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        return FollowerListToken.getFollowerListToken(display);
    }

    public static String getFollowerListToken(CharacterDisplay display) {
        StringBuilder buf = new StringBuilder();
        boolean needComma = false;
        for (Follower aF : display.getFollowerList()) {
            for (PlayerCharacter nPC : Globals.getPCList()) {
                CharacterDisplay nDisplay = nPC.getDisplay();
                if (!aF.getFileName().equals(nDisplay.getFileName())) continue;
                if (needComma) {
                    buf.append(", ");
                }
                buf.append(FileAccess.filterString(nDisplay.getName()));
                needComma = true;
            }
        }
        return buf.toString();
    }
}

