/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.fop;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.Renderer;
import pcgen.cdom.base.Constants;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;

public class FopTask
implements Runnable {
    private static final TransformerFactory TRANS_FACTORY = TransformerFactory.newInstance();
    private final StreamSource inputSource;
    private final StreamSource xsltSource;
    private final Renderer renderer;
    private final OutputStream outputStream;
    private StringBuilder errorBuilder = new StringBuilder(32);

    private static FopFactory createFopFactory() {
        FopFactory fopFactory = FopFactory.newInstance();
        fopFactory.setStrictValidation(false);
        String configPath = ConfigurationSettings.getOutputSheetsDir() + File.separator + "fop.xconf";
        Logging.log(Logging.INFO, "Checking for config file at " + configPath);
        File userConfigFile = new File(configPath);
        if (userConfigFile.exists()) {
            Logging.log(Logging.INFO, "FoPTask using config file " + configPath);
            try {
                fopFactory.setUserConfig(userConfigFile);
            }
            catch (Exception e) {
                Logging.errorPrint("Problem with FOP configuration " + configPath + ": ", e);
            }
        }
        return fopFactory;
    }

    private FopTask(StreamSource inputXml, StreamSource xsltSource, Renderer renderer, OutputStream outputStream) {
        this.inputSource = inputXml;
        this.xsltSource = xsltSource;
        this.renderer = renderer;
        this.outputStream = outputStream;
    }

    private static StreamSource createXsltStreamSource(File xsltFile) throws FileNotFoundException {
        if (xsltFile == null) {
            return null;
        }
        if (!xsltFile.exists()) {
            throw new FileNotFoundException("xsl file " + xsltFile.getAbsolutePath() + " not found ");
        }
        return new StreamSource(xsltFile);
    }

    public static FopTask newFopTask(InputStream inputXmlStream, File xsltFile, OutputStream outputPdf) throws FileNotFoundException {
        StreamSource xsltSource = FopTask.createXsltStreamSource(xsltFile);
        return new FopTask(new StreamSource(inputXmlStream), xsltSource, null, outputPdf);
    }

    public static FopTask newFopTask(InputStream inputXmlStream, File xsltFile, Renderer renderer) throws FileNotFoundException {
        StreamSource xsltSource = FopTask.createXsltStreamSource(xsltFile);
        return new FopTask(new StreamSource(inputXmlStream), xsltSource, renderer, null);
    }

    public String getErrorMessages() {
        return this.errorBuilder.toString();
    }

    @Override
    public void run() {
        try (OutputStream out = this.outputStream;){
            String mimeType;
            FopFactory factory = FopTask.createFopFactory();
            FOUserAgent userAgent = factory.newFOUserAgent();
            userAgent.setProducer("PC Gen Character Generator");
            userAgent.setAuthor(System.getProperty("user.name"));
            userAgent.setCreationDate(new Date());
            if (this.renderer != null) {
                userAgent.setKeywords("PCGEN FOP PREVIEW");
                userAgent.setRendererOverride(this.renderer);
                this.renderer.setUserAgent(userAgent);
                mimeType = "application/X-fop-awt-preview";
            } else {
                userAgent.setKeywords("PCGEN FOP PDF");
                mimeType = "application/pdf";
            }
            Fop fop = out != null ? factory.newFop(mimeType, userAgent, out) : factory.newFop(mimeType, userAgent);
            Transformer transformer = this.xsltSource != null ? TRANS_FACTORY.newTransformer(this.xsltSource) : TRANS_FACTORY.newTransformer();
            transformer.setErrorListener(new FOPErrorListener());
            transformer.transform(this.inputSource, new SAXResult(fop.getDefaultHandler()));
        }
        catch (IOException | TransformerException | FOPException e) {
            this.errorBuilder.append(e.getMessage()).append(Constants.LINE_SEPARATOR);
            Logging.errorPrint("Exception in FopTask:run", e);
        }
        catch (RuntimeException ex) {
            this.errorBuilder.append(ex.getMessage()).append(Constants.LINE_SEPARATOR);
            Logging.errorPrint("Unexpected exception in FopTask:run: ", ex);
        }
    }

    public static class FOPErrorListener
    implements ErrorListener {
        @Override
        public void error(TransformerException exception) throws TransformerException {
            SourceLocator locator = exception.getLocator();
            Logging.errorPrint("FOP Error " + exception.getMessage() + " at " + this.getLocation(locator));
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            SourceLocator locator = exception.getLocator();
            Logging.errorPrint("FOP Fatal Error " + exception.getMessage() + " at " + this.getLocation(locator));
            throw exception;
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            SourceLocator locator = exception.getLocator();
            Logging.log(Logging.WARNING, this.getLocation(locator) + exception.getMessage());
        }

        private String getLocation(SourceLocator locator) {
            if (locator == null) {
                return "Unknown; ";
            }
            StringBuilder builder = new StringBuilder();
            if (locator.getSystemId() != null) {
                builder.append(locator.getSystemId());
                builder.append("; ");
            }
            if (locator.getLineNumber() > -1) {
                builder.append("Line#: ");
                builder.append(locator.getLineNumber());
                builder.append("; ");
            }
            if (locator.getColumnNumber() > -1) {
                builder.append("Column#: ");
                builder.append(locator.getColumnNumber());
                builder.append("; ");
            }
            return builder.toString();
        }
    }
}

