/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public final class SourceLogFormatter
extends Formatter {
    private static final char SEPERATOR = ' ';
    private final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.S");
    private final Date date = new Date();
    private static final Pattern javaExtPattern = Pattern.compile("\\.java");

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.date.setTime(record.getMillis());
        sb.append(this.df.format(this.date));
        sb.append(' ');
        sb.append(String.valueOf(record.getLevel()));
        sb.append(' ');
        sb.append(Thread.currentThread().getName());
        sb.append(' ');
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement caller = null;
        for (int i = 1; i < stack.length; ++i) {
            if (stack[i].getClassName().startsWith("pcgen.util.Logging") || stack[i].getClassName().startsWith("java.util.logging") || stack[i].getClassName().startsWith("pcgen.system.LoggingRecorder")) continue;
            caller = stack[i];
            break;
        }
        if (caller != null) {
            if (caller.getLineNumber() >= 0) {
                sb.append(javaExtPattern.matcher(caller.getFileName()).replaceFirst(""));
                sb.append(':');
                sb.append(caller.getLineNumber());
            } else {
                sb.append(caller.getClassName());
                sb.append(' ');
                sb.append(caller.getMethodName());
            }
        }
        sb.append(' ');
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            sb.append('\n');
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.flush();
            sb.append(sw);
        }
        sb.append('\n');
        return sb.toString();
    }
}

