/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.CaseInsensitiveMap;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.TreeMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.GroupDefinition;
import pcgen.cdom.base.Loadable;
import pcgen.core.PCClass;
import pcgen.core.bonus.BonusObj;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.prereq.PreMultParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.persistence.token.CDOMCompatibilityToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.CDOMSubToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.token.ClassWrappedToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.PostDeferredToken;
import pcgen.rules.persistence.token.PostValidationToken;
import pcgen.rules.persistence.token.PreCompatibilityToken;
import pcgen.rules.persistence.token.PrimitiveToken;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.rules.persistence.util.TokenFamily;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public final class TokenLibrary
implements PluginLoader {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<CDOMObject> CDOMOBJECT_CLASS = CDOMObject.class;
    private static final TreeMapToList<Integer, PostDeferredToken<? extends Loadable>> POST_DEFERRED_TOKENS = new TreeMapToList();
    private static final TreeMapToList<Integer, PostValidationToken<? extends Loadable>> POST_VALIDATION_TOKENS = new TreeMapToList();
    private static final DoubleKeyMap<Class<?>, String, Class<? extends QualifierToken<?>>> QUALIFIER_MAP = new DoubleKeyMap();
    private static final DoubleKeyMap<Class<?>, String, Class<? extends PrimitiveToken<?>>> PRIMITIVE_MAP = new DoubleKeyMap();
    private static final Set<TokenFamily> TOKEN_FAMILIES = new TreeSet<TokenFamily>();
    private static final CaseInsensitiveMap<Class<? extends BonusObj>> BONUS_TAG_MAP = new CaseInsensitiveMap();
    private static TokenLibrary instance = null;

    public static void reset() {
        POST_DEFERRED_TOKENS.clear();
        QUALIFIER_MAP.clear();
        PRIMITIVE_MAP.clear();
        BONUS_TAG_MAP.clear();
        TOKEN_FAMILIES.clear();
        TokenFamily.CURRENT.clearTokens();
        TOKEN_FAMILIES.add(TokenFamily.CURRENT);
        TokenFamily.REV514.clearTokens();
        TOKEN_FAMILIES.add(TokenFamily.REV514);
        TokenLibrary.addToTokenMap(new PreMultParser());
    }

    private TokenLibrary() {
    }

    public static <T> PrimitiveToken<T> getPrimitive(Class<T> cl, String tokKey) {
        PrimitiveTokenIterator it = new PrimitiveTokenIterator(cl, tokKey);
        if (it.hasNext()) {
            return (PrimitiveToken)it.next();
        }
        return null;
    }

    public static Collection<PostDeferredToken<? extends Loadable>> getPostDeferredTokens() {
        ArrayList<PostDeferredToken<? extends Loadable>> list = new ArrayList<PostDeferredToken<? extends Loadable>>();
        for (Integer key : POST_DEFERRED_TOKENS.getKeySet()) {
            list.addAll(POST_DEFERRED_TOKENS.getListFor((Object)key));
        }
        return list;
    }

    public static Collection<PostValidationToken<? extends Loadable>> getPostValidationTokens() {
        ArrayList<PostValidationToken<? extends Loadable>> list = new ArrayList<PostValidationToken<? extends Loadable>>();
        for (Integer key : POST_VALIDATION_TOKENS.getKeySet()) {
            list.addAll(POST_VALIDATION_TOKENS.getListFor((Object)key));
        }
        return list;
    }

    public static void addToPrimitiveMap(PrimitiveToken<?> p) {
        Class<?> newTokClass = p.getClass();
        if (PrimitiveToken.class.isAssignableFrom(newTokClass)) {
            String name = p.getTokenName();
            Class cl = p.getReferenceClass();
            Class prev = (Class)PRIMITIVE_MAP.put(cl, (Object)name, newTokClass);
            if (prev != null) {
                Logging.errorPrint("Found a second " + name + " Primitive for " + cl);
            }
        }
    }

    public static void addToQualifierMap(QualifierToken<?> p) {
        String name;
        Class<?> newTokClass = p.getClass();
        Class cl = p.getReferenceClass();
        Class prev = (Class)QUALIFIER_MAP.put(cl, (Object)(name = p.getTokenName()), newTokClass);
        if (prev != null) {
            Logging.errorPrint("Found a second " + name + " Qualifier for " + cl);
        }
    }

    public static void addToTokenMap(Object newToken) {
        Object pdt;
        if (newToken instanceof PostDeferredToken) {
            pdt = (PostDeferredToken)newToken;
            POST_DEFERRED_TOKENS.addToListFor((Object)pdt.getPriority(), pdt);
        }
        if (newToken instanceof PostValidationToken) {
            pdt = (PostValidationToken)newToken;
            POST_VALIDATION_TOKENS.addToListFor((Object)pdt.getPriority(), pdt);
        }
        if (newToken instanceof CDOMCompatibilityToken) {
            CDOMCompatibilityToken tok = (CDOMCompatibilityToken)newToken;
            TokenFamily fam = TokenFamily.getConstant(tok.compatibilityLevel(), tok.compatibilitySubLevel(), tok.compatibilityPriority());
            if (fam.putToken(tok) != null) {
                Logging.errorPrint("Duplicate " + tok.getTokenClass().getSimpleName() + " Compatibility Token found for token " + tok.getTokenName() + " at compatibility level " + tok.compatibilityLevel() + "." + tok.compatibilitySubLevel() + "." + tok.compatibilityPriority());
            }
            TOKEN_FAMILIES.add(fam);
            if (fam.compareTo(TokenFamily.REV514) <= 0 && PCCLASS_CLASS.equals(tok.getTokenClass())) {
                CDOMCompatibilityToken clTok = tok;
                TokenLibrary.addToTokenMap(new ClassWrappedToken(clTok));
            }
        }
        TokenLibrary.loadFamily(TokenFamily.CURRENT, newToken);
    }

    public static void loadFamily(TokenFamily family, Object newToken) {
        CDOMToken existingToken;
        CDOMToken<PCClass> tok;
        if (newToken instanceof DeferredToken) {
            family.addDeferredToken((DeferredToken)newToken);
        }
        if (newToken instanceof CDOMPrimaryToken) {
            tok = (CDOMPrimaryToken)newToken;
            existingToken = family.putToken(tok);
            if (existingToken != null) {
                Logging.errorPrint("Duplicate " + tok.getTokenClass().getSimpleName() + " Token found for token " + tok.getTokenName() + ". Classes were " + existingToken.getClass().getName() + " and " + newToken.getClass().getName());
            }
            if (PCCLASS_CLASS.equals(tok.getTokenClass())) {
                CDOMToken<PCClass> clTok = tok;
                TokenLibrary.addToTokenMap(new ClassWrappedToken(clTok));
            }
        }
        if (newToken instanceof CDOMSecondaryToken && (existingToken = family.putSubToken(tok = (CDOMSecondaryToken)newToken)) != null) {
            Logging.errorPrint("Duplicate " + tok.getTokenClass().getSimpleName() + " Token found for token " + tok.getParentToken() + ":" + tok.getTokenName() + ". Classes were " + existingToken.getClass().getName() + " and " + newToken.getClass().getName());
        }
        if (newToken instanceof PrerequisiteParserInterface) {
            PrerequisiteParserInterface prereqToken = (PrerequisiteParserInterface)newToken;
            family.putPrerequisiteToken(prereqToken);
            for (String s : prereqToken.kindsHandled()) {
                PreCompatibilityToken pos = new PreCompatibilityToken(s, prereqToken, false);
                if (family.putToken(pos) != null) {
                    Logging.errorPrint("Duplicate " + pos.getTokenClass().getSimpleName() + " Token found for token " + pos.getTokenName());
                }
                if (family.putSubToken(pos) != null) {
                    Logging.errorPrint("Duplicate " + pos.getTokenClass().getSimpleName() + " Token found for token " + pos.getParentToken() + ":" + pos.getTokenName());
                }
                family.putSubToken(pos);
                PreCompatibilityToken neg = new PreCompatibilityToken(s, prereqToken, true);
                if (family.putToken(neg) != null) {
                    Logging.errorPrint("Duplicate " + neg.getTokenClass().getSimpleName() + " Token found for token " + neg.getTokenName());
                }
                if (family.putSubToken(neg) == null) continue;
                Logging.errorPrint("Duplicate " + neg.getTokenClass().getSimpleName() + " Token found for token " + neg.getParentToken() + ":" + neg.getTokenName());
            }
        }
        if (newToken instanceof GroupDefinition) {
            family.addGroupDefinition((GroupDefinition)newToken);
        }
    }

    public static TokenLibrary getInstance() {
        if (instance == null) {
            instance = new TokenLibrary();
        }
        return instance;
    }

    @Override
    public void loadPlugin(Class<?> clazz) throws Exception {
        if (BonusObj.class.isAssignableFrom(clazz)) {
            TokenLibrary.addBonusClass(clazz);
        }
        Object token = clazz.newInstance();
        if (LstToken.class.isAssignableFrom(clazz) || PrerequisiteParserInterface.class.isAssignableFrom(clazz)) {
            TokenLibrary.addToTokenMap(token);
        }
        if (QualifierToken.class.isAssignableFrom(clazz)) {
            TokenLibrary.addToQualifierMap((QualifierToken)token);
        }
        if (PrimitiveToken.class.isAssignableFrom(clazz)) {
            TokenLibrary.addToPrimitiveMap((PrimitiveToken)token);
        }
    }

    public Class[] getPluginClasses() {
        return new Class[]{LstToken.class, BonusObj.class, PrerequisiteParserInterface.class};
    }

    public static boolean addBonusClass(Class bonusClass) throws InstantiationException, IllegalAccessException {
        if (BonusObj.class.isAssignableFrom(bonusClass)) {
            BonusObj bonusObj = (BonusObj)bonusClass.newInstance();
            BONUS_TAG_MAP.put((Object)bonusObj.getBonusHandled(), (Object)bonusClass);
            return true;
        }
        return false;
    }

    public static Class<? extends BonusObj> getBonus(String bonusName) {
        return (Class)BONUS_TAG_MAP.get((Object)bonusName);
    }

    static {
        TokenLibrary.reset();
    }

    static class PreTokenIterator
    extends AbstractTokenIterator<CDOMObject, PrerequisiteParserInterface> {
        public PreTokenIterator(String key) {
            super(CDOMOBJECT_CLASS, key);
        }

        @Override
        protected PrerequisiteParserInterface grabToken(TokenFamily family, Class<?> cl, String key) {
            return family.getPrerequisiteToken(key);
        }
    }

    static class PrimitiveTokenIterator<C, T extends PrimitiveToken<? super C>>
    extends AbstractTokenIterator<C, T> {
        public PrimitiveTokenIterator(Class<C> cl, String key) {
            super(cl, key);
        }

        @Override
        protected T grabToken(TokenFamily family, Class<?> cl, String key) {
            if (!TokenFamily.CURRENT.equals(family)) {
                return null;
            }
            Class cl1 = (Class)PRIMITIVE_MAP.get(cl, (Object)key);
            if (cl1 == null) {
                return null;
            }
            try {
                return (T)((PrimitiveToken)cl1.newInstance());
            }
            catch (InstantiationException e) {
                throw new UnreachableError("new Instance on " + cl1 + " should not fail", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnreachableError("new Instance on " + cl1 + " should not fail due to access", (Throwable)e);
            }
        }
    }

    static class QualifierTokenIterator<C extends CDOMObject, T extends QualifierToken<? super C>>
    extends AbstractTokenIterator<C, T> {
        public QualifierTokenIterator(Class<C> cl, String key) {
            super(cl, key);
        }

        @Override
        protected T grabToken(TokenFamily family, Class<?> cl, String key) {
            if (!TokenFamily.CURRENT.equals(family)) {
                return null;
            }
            Class cl1 = (Class)QUALIFIER_MAP.get(cl, (Object)key);
            if (cl1 == null) {
                return null;
            }
            try {
                return (T)((QualifierToken)cl1.newInstance());
            }
            catch (InstantiationException e) {
                throw new UnreachableError("new Instance on " + cl1 + " should not fail", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UnreachableError("new Instance on " + cl1 + " should not fail due to access", (Throwable)e);
            }
        }
    }

    static class SubTokenIterator<C, T extends CDOMSubToken<? super C>>
    extends AbstractTokenIterator<C, T> {
        private final String subTokenKey;

        public SubTokenIterator(Class<C> cl, String key, String subKey) {
            super(cl, key);
            this.subTokenKey = subKey;
        }

        @Override
        protected T grabToken(TokenFamily family, Class<?> cl, String key) {
            return (T)family.getSubToken(cl, key, this.subTokenKey);
        }
    }

    static class TokenIterator<C extends Loadable, T extends CDOMToken<? super C>>
    extends AbstractTokenIterator<C, T> {
        public TokenIterator(Class<C> cl, String key) {
            super(cl, key);
        }

        @Override
        protected T grabToken(TokenFamily family, Class<?> cl, String key) {
            return (T)family.getToken(cl, key);
        }
    }

    static abstract class AbstractTokenIterator<C, T>
    implements Iterator<T> {
        private final Class<C> rootClass;
        private final String tokenKey;
        private T nextToken = null;
        private boolean needNewToken = true;
        private Class<?> stopClass;
        private final Iterator<TokenFamily> subIterator;

        public AbstractTokenIterator(Class<C> cl, String key) {
            this.rootClass = cl;
            this.subIterator = TOKEN_FAMILIES.iterator();
            this.tokenKey = key;
        }

        @Override
        public boolean hasNext() {
            this.setNextToken();
            return !this.needNewToken;
        }

        protected void setNextToken() {
            while (this.needNewToken && this.subIterator.hasNext()) {
                Class<C> actingClass;
                TokenFamily family = this.subIterator.next();
                this.nextToken = this.grabToken(family, actingClass, this.tokenKey);
                for (actingClass = this.rootClass; this.nextToken == null && actingClass != null && !actingClass.equals(this.stopClass); actingClass = actingClass.getSuperclass()) {
                    this.nextToken = this.grabToken(family, actingClass, this.tokenKey);
                }
                if (this.stopClass == null) {
                    this.stopClass = actingClass;
                }
                this.needNewToken = this.nextToken == null;
            }
        }

        protected abstract T grabToken(TokenFamily var1, Class<?> var2, String var3);

        @Override
        public T next() {
            this.setNextToken();
            if (this.needNewToken) {
                throw new NoSuchElementException();
            }
            this.needNewToken = true;
            return this.nextToken;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator does not support remove");
        }
    }
}

