/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.table;

import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableColumn;
import pcgen.gui2.util.table.TableCellUtilities;

public class TableUtils {
    public static JTable createDefaultTable() {
        JTable table = new JTable();
        table.setFillsViewportHeight(true);
        return table;
    }

    public static JScrollPane createCheckBoxSelectionPane(JTable table, JTable rowheaderTable) {
        return TableUtils.createToggleButtonSelectionPane(table, rowheaderTable, new JCheckBox());
    }

    public static JScrollPane createRadioBoxSelectionPane(JTable table, JTable rowheaderTable) {
        rowheaderTable.setDefaultEditor(Boolean.class, new TableCellUtilities.RadioButtonEditor());
        return TableUtils.createToggleButtonSelectionPane(table, rowheaderTable, new JRadioButton());
    }

    private static JScrollPane createToggleButtonSelectionPane(JTable table, JTable rowheaderTable, JToggleButton button) {
        rowheaderTable.setAutoCreateColumnsFromModel(false);
        rowheaderTable.setModel(table.getModel());
        rowheaderTable.setSelectionModel(table.getSelectionModel());
        rowheaderTable.setRowHeight(table.getRowHeight());
        rowheaderTable.setIntercellSpacing(table.getIntercellSpacing());
        rowheaderTable.setShowGrid(false);
        rowheaderTable.setFocusable(false);
        TableColumn column = new TableColumn(-1);
        column.setHeaderValue(new Object());
        column.setCellRenderer(new TableCellUtilities.ToggleButtonRenderer(button));
        rowheaderTable.addColumn(column);
        rowheaderTable.setPreferredScrollableViewportSize(new Dimension(20, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(table);
        scrollPane.setRowHeaderView(rowheaderTable);
        return scrollPane;
    }
}

