/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.skill;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.tabs.Utilities;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.table.TableCellUtilities;

public class SkillPointTableModel
extends AbstractTableModel
implements ListListener<CharacterLevelFacade>,
CharacterLevelsFacade.ClassListener,
CharacterLevelsFacade.SkillPointListener {
    private CharacterLevelsFacade levels;

    public SkillPointTableModel(CharacterFacade character) {
        this.levels = character.getCharacterLevelsFacade();
        this.levels.addListListener(this);
        this.levels.addClassListener(this);
        this.levels.addSkillPointListener(this);
    }

    public static void initializeTable(JTable table) {
        table.setAutoCreateColumnsFromModel(false);
        JTableHeader header = table.getTableHeader();
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        TableCellRenderer headerRenderer = header.getDefaultRenderer();
        columns.addColumn(Utilities.createTableColumn(0, "in_level", headerRenderer, false));
        columns.addColumn(Utilities.createTableColumn(1, "in_class", headerRenderer, true));
        TableColumn remainCol = Utilities.createTableColumn(2, "in_iskRemain", headerRenderer, false);
        remainCol.setCellRenderer(new BoldNumberRenderer());
        columns.addColumn(remainCol);
        columns.addColumn(Utilities.createTableColumn(3, "in_gained", headerRenderer, false));
        table.setDefaultRenderer(Integer.class, new TableCellUtilities.AlignRenderer(0));
        table.setColumnModel(columns);
        table.setFocusable(false);
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
    }

    @Override
    public int getRowCount() {
        return this.levels.getSize();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return Object.class;
            }
            case 0: 
            case 2: 
            case 3: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex + 1;
        }
        CharacterLevelFacade level = (CharacterLevelFacade)this.levels.getElementAt(rowIndex);
        switch (columnIndex) {
            case 1: {
                return this.levels.getClassTaken(level);
            }
            case 2: {
                return this.levels.getRemainingSkillPoints(level);
            }
            case 3: {
                return this.levels.getGainedSkillPoints(level);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        CharacterLevelFacade level = (CharacterLevelFacade)this.levels.getElementAt(rowIndex);
        this.levels.setGainedSkillPoints(level, (Integer)aValue);
    }

    @Override
    public void elementAdded(ListEvent<CharacterLevelFacade> e) {
        this.fireTableRowsInserted(e.getIndex(), e.getIndex());
    }

    @Override
    public void elementRemoved(ListEvent<CharacterLevelFacade> e) {
        this.fireTableRowsDeleted(e.getIndex(), e.getIndex());
    }

    @Override
    public void elementsChanged(ListEvent<CharacterLevelFacade> e) {
        this.fireTableDataChanged();
    }

    @Override
    public void elementModified(ListEvent<CharacterLevelFacade> e) {
        this.fireTableRowsUpdated(e.getIndex(), e.getIndex());
    }

    @Override
    public void skillPointsChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        this.levelChanged(e);
    }

    @Override
    public void classChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        this.levelChanged(e);
    }

    private void levelChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        int firstRow = e.getBaseLevelIndex();
        int lastRow = e.affectsHigherLevels() ? this.levels.getSize() - 1 : firstRow;
        this.fireTableRowsUpdated(firstRow, lastRow);
    }

    private static class BoldNumberRenderer
    extends DefaultTableCellRenderer {
        public BoldNumberRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            comp.setFont(FontManipulation.bold(table.getFont()));
            return this;
        }
    }
}

