/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.NoteFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.bio.BiographyInfoPane;
import pcgen.gui2.tabs.bio.CampaignHistoryInfoPane;
import pcgen.gui2.tabs.bio.NoteInfoPane;
import pcgen.gui2.tabs.bio.PortraitInfoPane;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class DescriptionInfoTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private final TabTitle tabTitle = new TabTitle(Tab.DESCRIPTION);
    private final PortraitInfoPane portraitPane = new PortraitInfoPane();
    private final BiographyInfoPane bioPane = new BiographyInfoPane();
    private final CampaignHistoryInfoPane histPane = new CampaignHistoryInfoPane();
    private final JList pageList = new JList();
    private final JButton addButton = new JButton();
    private final JPanel pagePanel = new JPanel();

    public DescriptionInfoTab() {
        super("Desc");
        this.initComponents();
    }

    private void initComponents() {
        this.addButton.setAlignmentX(0.5f);
        Box box = Box.createVerticalBox();
        box.add(new JScrollPane(this.pageList));
        box.add(Box.createVerticalStrut(5));
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createRigidArea(new Dimension(8, 0)));
        hbox.add(this.addButton);
        hbox.add(Box.createRigidArea(new Dimension(8, 0)));
        box.add(hbox);
        box.add(Box.createVerticalStrut(4));
        this.setLeftComponent(box);
        CardLayout pages = new CardLayout();
        this.pagePanel.setLayout(pages);
        this.addPage(this.bioPane);
        this.addPage(this.portraitPane);
        this.addPage(this.histPane);
        this.setRightComponent(this.pagePanel);
        this.setResizeWeight(0.0);
    }

    private <T extends Component> void addPage(T page) {
        this.pagePanel.add(page, ((CharacterInfoTab)((Object)page)).getTabTitle().getValue("title"));
    }

    private <T extends Component> void removePage(T page) {
        this.pagePanel.remove(page);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        DefaultListModel<PageItem> listModel = new DefaultListModel<PageItem>();
        ArrayList<NoteInfoPane> notePaneList = new ArrayList<NoteInfoPane>();
        PageItem firstPage = new PageItem(character, LanguageBundle.getString("in_descBiography"), (CharacterInfoTab)this.bioPane);
        listModel.addElement(firstPage);
        listModel.addElement(new PageItem(character, LanguageBundle.getString("in_portrait"), (CharacterInfoTab)this.portraitPane));
        listModel.addElement(new PageItem(character, LanguageBundle.getString("in_descCampHist"), (CharacterInfoTab)this.histPane));
        models.put(ListModel.class, listModel);
        models.put(List.class, notePaneList);
        models.put(NoteListHandler.class, new NoteListHandler(character, listModel, notePaneList));
        DefaultListSelectionModel model = new DefaultListSelectionModel();
        model.setSelectionMode(0);
        model.setSelectionInterval(0, 0);
        models.put(ListSelectionModel.class, model);
        models.put(PageHandler.class, new PageHandler(model, firstPage));
        models.put(AddAction.class, new AddAction(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        this.pageList.setModel(models.get(ListModel.class));
        this.pageList.setSelectionModel(models.get(ListSelectionModel.class));
        models.get(NoteListHandler.class).install();
        models.get(PageHandler.class).install();
        this.addButton.setAction(models.get(AddAction.class));
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        this.pageList.setSelectionModel(new DefaultListSelectionModel());
        models.get(PageHandler.class).uninstall();
        models.get(NoteListHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    private class AddAction
    extends AbstractAction {
        private final CharacterFacade character;

        public AddAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_descAddPage"));
            this.character = character;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.getDescriptionFacade().addNewNote();
        }
    }

    private class PageHandler
    implements ListSelectionListener {
        private final ListSelectionModel selectionModel;
        private PageItem currentPage;

        public PageHandler(ListSelectionModel selectionModel, PageItem currentPage) {
            this.selectionModel = selectionModel;
            this.currentPage = currentPage;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            PageItem item = (PageItem)DescriptionInfoTab.this.pageList.getSelectedValue();
            if (item == null) {
                return;
            }
            this.currentPage.storeModels();
            this.currentPage = item;
            this.currentPage.restoreModels();
            CardLayout pages = (CardLayout)DescriptionInfoTab.this.pagePanel.getLayout();
            pages.show(DescriptionInfoTab.this.pagePanel, this.currentPage.id);
        }

        public void install() {
            this.selectionModel.addListSelectionListener(this);
            this.currentPage.restoreModels();
            CardLayout pages = (CardLayout)DescriptionInfoTab.this.pagePanel.getLayout();
            pages.show(DescriptionInfoTab.this.pagePanel, this.currentPage.id);
        }

        public void uninstall() {
            this.selectionModel.removeListSelectionListener(this);
            this.currentPage.storeModels();
        }
    }

    private static class PageItem {
        private NoteFacade note;
        private String name;
        private String id;
        private CharacterInfoTab page;
        private CharacterInfoTab.ModelMap data;

        public PageItem(CharacterFacade character, NoteFacade note, CharacterInfoTab page) {
            this.note = note;
            this.name = "";
            this.id = (String)page.getTabTitle().getValue("title");
            this.page = page;
            this.data = page.createModels(character);
        }

        public PageItem(CharacterFacade character, String name, CharacterInfoTab page) {
            this.note = null;
            this.name = name;
            this.id = (String)page.getTabTitle().getValue("title");
            this.page = page;
            this.data = page.createModels(character);
        }

        public String toString() {
            return this.note == null ? this.name : this.note.getName();
        }

        public void storeModels() {
            this.page.storeModels(this.data);
        }

        public void restoreModels() {
            this.page.restoreModels(this.data);
        }
    }

    private class NoteListHandler
    implements ListListener<NoteFacade> {
        private static final int NUM_NON_NOTE_NODES = 3;
        private ListFacade<NoteFacade> notes;
        private final DefaultListModel listModel;
        private final List<NoteInfoPane> notePaneList;
        private final CharacterFacade character;

        public NoteListHandler(CharacterFacade character, DefaultListModel listModel, List<NoteInfoPane> notePaneList) {
            this.character = character;
            this.listModel = listModel;
            this.notePaneList = notePaneList;
            this.notes = character.getDescriptionFacade().getNotes();
            for (NoteFacade note : this.notes) {
                this.createNotePane(note, character, listModel, notePaneList, -1);
            }
        }

        private NoteInfoPane createNotePane(NoteFacade note, CharacterFacade character, DefaultListModel listModel, List<NoteInfoPane> notePaneList, int pos) {
            NoteInfoPane notePane = new NoteInfoPane(note);
            PageItem pageItem = new PageItem(character, note, (CharacterInfoTab)notePane);
            if (pos >= 0 && pos < notePaneList.size()) {
                listModel.insertElementAt(pageItem, pos + 3);
                notePaneList.add(pos, notePane);
            } else {
                listModel.addElement(pageItem);
                notePaneList.add(notePane);
            }
            return notePane;
        }

        public void install() {
            this.notes.addListListener(this);
            for (NoteInfoPane noteInfoPane : this.notePaneList) {
                DescriptionInfoTab.this.addPage(noteInfoPane);
            }
        }

        public void uninstall() {
            this.notes.removeListListener(this);
            for (NoteInfoPane noteInfoPane : this.notePaneList) {
                DescriptionInfoTab.this.removePage(noteInfoPane);
            }
        }

        @Override
        public void elementAdded(ListEvent<NoteFacade> e) {
            NoteFacade note = e.getElement();
            NoteInfoPane notePane = this.createNotePane(note, this.character, this.listModel, this.notePaneList, e.getIndex());
            DescriptionInfoTab.this.addPage(notePane);
        }

        @Override
        public void elementRemoved(ListEvent<NoteFacade> e) {
            NoteFacade note = e.getElement();
            if (note == null) {
                return;
            }
            this.removeNote(note);
            int index = e.getIndex() + 3;
            if (index >= DescriptionInfoTab.this.pageList.getModel().getSize()) {
                index = DescriptionInfoTab.this.pageList.getModel().getSize() - 1;
            }
            DescriptionInfoTab.this.pageList.setSelectedIndex(index);
        }

        private void removeNote(NoteFacade note) {
            Iterator<NoteInfoPane> iterator = this.notePaneList.iterator();
            while (iterator.hasNext()) {
                NoteInfoPane pane = iterator.next();
                if (!pane.getNote().equals(note)) continue;
                iterator.remove();
                break;
            }
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                PageItem item = (PageItem)this.listModel.elementAt(i);
                if (note != item.note) continue;
                this.listModel.removeElement(item);
                break;
            }
        }

        @Override
        public void elementsChanged(ListEvent<NoteFacade> e) {
            for (NoteInfoPane pane : this.notePaneList) {
                this.listModel.removeElement(pane);
            }
            this.notePaneList.clear();
            for (NoteFacade note : this.notes) {
                this.createNotePane(note, this.character, this.listModel, this.notePaneList, -1);
            }
        }

        @Override
        public void elementModified(ListEvent<NoteFacade> e) {
            NoteFacade note = e.getElement();
            if (note == null) {
                return;
            }
            int noteIndex = e.getIndex();
            this.listModel.set(noteIndex, this.listModel.getElementAt(noteIndex));
        }
    }
}

