/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import pcgen.core.Equipment;
import pcgen.core.SettingsHandler;
import pcgen.system.PCGenPropBundle;
import pcgen.util.Logging;

public final class CoreUtility {
    private static final double epsilon = 1.0E-4;
    public static final Comparator<Equipment> equipmentComparator = new Comparator<Equipment>(){

        private int compareInts(int obj1Index, int obj2Index) {
            if (obj1Index > obj2Index) {
                return 1;
            }
            if (obj1Index < obj2Index) {
                return -1;
            }
            return 0;
        }

        @Override
        public int compare(Equipment obj1, Equipment obj2) {
            int o1i = obj1.getOutputIndex();
            int o2i = obj2.getOutputIndex();
            int result1 = this.compareInts(o1i = o1i == 0 ? 999 : o1i, o2i = o2i == 0 ? 999 : o2i);
            if (result1 != 0) {
                return result1;
            }
            int result2 = this.compareInts(obj1.getOutputSubindex(), obj2.getOutputSubindex());
            if (result2 != 0) {
                return result2;
            }
            int result3 = obj1.getName().compareToIgnoreCase(obj2.getName());
            if (result3 != 0) {
                return result3;
            }
            int result4 = obj1.getAppliedName().compareToIgnoreCase(obj2.getAppliedName());
            if (result4 != 0) {
                return result4;
            }
            return obj1.getParentName().compareToIgnoreCase(obj2.getParentName());
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }
    };

    private CoreUtility() {
    }

    public static boolean isNetURL(URL url) {
        return "http".equalsIgnoreCase(url.getProtocol()) || "ftp".equalsIgnoreCase(url.getProtocol());
    }

    public static String capitalizeFirstLetter(String aString) {
        boolean toUpper = true;
        char[] a = aString.toLowerCase().toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (Character.isWhitespace(a[i])) {
                toUpper = true;
                continue;
            }
            if (toUpper && Character.isLowerCase(a[i])) {
                a[i] = Character.toUpperCase(a[i]);
            }
            toUpper = false;
        }
        return new String(a);
    }

    public static boolean compareDouble(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    public static boolean doublesEqual(double a, double b) {
        return CoreUtility.compareDouble(a, b, 1.0E-4);
    }

    public static double epsilonFloor(double d) {
        return Math.floor(d + 1.0E-4);
    }

    public static String fixFilenamePath(String argFileName) {
        return argFileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static int innerMostStringEnd(String aString) {
        int index = 0;
        int hi = 0;
        int current = 0;
        for (int i = 0; i < aString.length(); ++i) {
            if (aString.charAt(i) == '(') {
                if (++current <= hi) continue;
                hi = current;
                continue;
            }
            if (aString.charAt(i) != ')') continue;
            if (current == hi) {
                index = i;
            }
            --current;
        }
        return index;
    }

    public static int innerMostStringStart(String aString) {
        int index = 0;
        int hi = 0;
        int current = 0;
        for (int i = 0; i < aString.length(); ++i) {
            if (aString.charAt(i) == '(') {
                if (++current < hi) continue;
                hi = current;
                index = i;
                continue;
            }
            if (aString.charAt(i) != ')') continue;
            --current;
        }
        return index;
    }

    public static String ordinal(int iValue) {
        String suffix = "th";
        if (iValue < 4 || iValue > 20) {
            switch (iValue % 10) {
                case 1: {
                    suffix = "st";
                    break;
                }
                case 2: {
                    suffix = "nd";
                    break;
                }
                case 3: {
                    suffix = "rd";
                    break;
                }
            }
        }
        return Integer.toString(iValue) + suffix;
    }

    public static List<String> split(String aString, char separator) {
        ArrayList<String> temp = new ArrayList<String>();
        String sepStr = Pattern.quote(String.valueOf(separator));
        if (aString.trim().length() == 0) {
            return temp;
        }
        for (String s : Arrays.asList(aString.split(sepStr))) {
            temp.add(s.trim());
        }
        return temp;
    }

    public static String unEscapeColons2(String in) {
        return in.replaceAll(Pattern.quote("&#59;"), ":");
    }

    public static List<Equipment> mergeEquipmentList(Collection<Equipment> equip, int merge) {
        ArrayList<Equipment> workingList = new ArrayList<Equipment>();
        for (Equipment e : equip) {
            workingList.add(e.clone());
        }
        Collections.sort(workingList, equipmentComparator);
        if (merge == 1) {
            return workingList;
        }
        int endIndex = workingList.size();
        for (int i = 0; i < endIndex; ++i) {
            Equipment eq1 = (Equipment)workingList.get(i);
            double eQty = eq1.qty();
            for (int j = i + 1; j < endIndex; ++j) {
                Equipment eq2 = (Equipment)workingList.get(j);
                if (eq1.isContainer() || eq1.isType("TEMPORARY") || eq2.isType("TEMPORARY") || !eq1.getName().equals(eq2.getName()) || merge != 0 && (merge != 2 || eq1.getLocation() != eq2.getLocation() || !eq1.getParentName().equals(eq2.getParentName()))) continue;
                workingList.remove(eq2);
                eQty += eq2.qty();
                --endIndex;
            }
            ((Equipment)workingList.get(i)).setQty(eQty);
        }
        return workingList;
    }

    public static int compareVersions(int[] ver, int[] compVer) {
        if (ver[0] != compVer[0]) {
            return Integer.valueOf(ver[0]).compareTo(compVer[0]);
        }
        if (ver[1] != compVer[1]) {
            return Integer.valueOf(ver[1]).compareTo(compVer[1]);
        }
        return Integer.valueOf(ver[2]).compareTo(compVer[2]);
    }

    public static int compareVersions(String ver, String compVer) {
        if (!ver.equals(compVer)) {
            return CoreUtility.compareVersions(CoreUtility.convertVersionToNumber(ver), CoreUtility.convertVersionToNumber(compVer));
        }
        return 0;
    }

    public static boolean isPriorToCurrent(String version) {
        return CoreUtility.compareVersions(version, PCGenPropBundle.getVersionNumber()) <= 0;
    }

    public static int[] convertVersionToNumber(String version) {
        int[] intVer = new int[]{0, 0, 0};
        String[] tokens = version.split(" |\\.|\\-", 4);
        for (int idx = 0; idx < 3 && idx < tokens.length; ++idx) {
            try {
                intVer[idx] = Integer.parseInt(tokens[idx]);
                continue;
            }
            catch (NumberFormatException e) {
                if (idx == 2 && tokens[idx].startsWith("RC")) continue;
                Logging.errorPrint("Invalid PCGen version: " + version);
            }
        }
        return intVer;
    }

    public static boolean isCurrMinorVer(String ver) {
        int[] currVer;
        if (ver.equals(PCGenPropBundle.getVersionNumber())) {
            return true;
        }
        int[] inVer = CoreUtility.convertVersionToNumber(ver);
        return inVer[0] == (currVer = CoreUtility.convertVersionToNumber(PCGenPropBundle.getVersionNumber()))[0] && inVer[1] == currVer[1];
    }

    public static boolean sameMajorMinorVer(int[] ver1, int[] ver2) {
        return ver1[0] == ver2[0] && ver1[1] == ver2[1];
    }

    public static URL processFileToURL(String value) throws MalformedURLException {
        StringBuilder inputPath = new StringBuilder(100);
        inputPath.append(SettingsHandler.getPcgenSponsorDir().getAbsolutePath());
        inputPath.append(File.separator).append(value);
        String convertedPath = CoreUtility.fixFilenamePath(inputPath.toString());
        if (!convertedPath.startsWith(File.separator)) {
            convertedPath = File.separator + convertedPath;
        }
        return new URL("file:" + inputPath);
    }
}

