/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;

public class SkillRankControl {
    public static Float getTotalRank(PlayerCharacter pc, Skill sk) {
        if (pc == null) {
            Logging.errorPrint("Asked to get total rank for null character. Location was ", new Throwable());
            return Float.valueOf(0.0f);
        }
        Float rank = pc.getRank(sk);
        if (rank == null) {
            Logging.errorPrint("Rank of skill " + sk + " for " + pc + " was null. Location was ", new Throwable());
            return Float.valueOf(0.0f);
        }
        double baseRanks = rank.doubleValue();
        double ranks = baseRanks + SkillRankControl.getSkillRankBonusTo(pc, sk);
        if (!Globals.checkRule("SKILLMAX") && pc.hasClass()) {
            double maxRanks = pc.getMaxRank(sk, pc.getClassList().get(0)).doubleValue();
            maxRanks = Math.max(maxRanks, baseRanks);
            ranks = Math.min(maxRanks, ranks);
        }
        return new Float(ranks);
    }

    public static void setZeroRanks(PCClass aClass, PlayerCharacter aPC, Skill sk) {
        if (aClass == null) {
            return;
        }
        Double rank = aPC.getSkillRankForClass(sk, aClass);
        if (rank != null) {
            aPC.removeSkillRankValue(sk, aClass);
            String aResp = SkillRankControl.modRanks(-rank.doubleValue(), aClass, false, aPC, sk);
            if (aResp.length() != 0) {
                Logging.debugPrint(aResp);
            }
        }
    }

    public static String modRanks(double rankMod, PCClass aClass, boolean ignorePrereqs, PlayerCharacter aPC, Skill sk) {
        Double rank;
        double currentRank;
        int i = 0;
        if (!ignorePrereqs) {
            if (aClass == null) {
                return "You must be at least level one before you can purchase skills.";
            }
            if (rankMod > 0.0 && !sk.qualifies(aPC, sk)) {
                return "You do not meet the prerequisites required to take this skill.";
            }
            SkillCost sc = aPC.getSkillCostForClass(sk, aClass);
            i = sc.getCost();
            if (i == 0) {
                return "You cannot purchase this exclusive skill.";
            }
            if (rankMod > 0.0 && (double)aClass.getSkillPool(aPC) < rankMod * (double)i) {
                return "You do not have enough skill points.";
            }
            double maxRank = aPC.getMaxRank(sk, aClass).doubleValue();
            if (!Globals.checkRule("SKILLMAX") && rankMod > 0.0) {
                double ttlRank = SkillRankControl.getTotalRank(aPC, sk).doubleValue();
                if (ttlRank >= maxRank) {
                    return "Skill rank at maximum (" + maxRank + ") for your level.";
                }
                if (ttlRank + rankMod > maxRank) {
                    return "Raising skill would make it above maximum (" + maxRank + ") for your level.";
                }
            }
        }
        if (aPC.getRank(sk).doubleValue() + rankMod < 0.0) {
            return "Cannot lower rank below 0";
        }
        String classKey = "None";
        if (aClass != null) {
            classKey = aClass.getKeyName();
        }
        double d = currentRank = (rank = aPC.getSkillRankForClass(sk, aClass)) == null ? 0.0 : rank;
        if (CoreUtility.doublesEqual(currentRank, 0.0) && rankMod < 0.0) {
            return "No more ranks found for class: " + classKey + ". Try a different one.";
        }
        rankMod = SkillRankControl.modRanks2(rankMod, currentRank, aClass, aPC, sk);
        if (!ignorePrereqs && aClass != null) {
            aPC.setSkillPool(aClass, aClass.getSkillPool(aPC) - (int)((double)i * rankMod));
        }
        return "";
    }

    public static void replaceClassRank(PlayerCharacter pc, Skill sk, PCClass oldClass, PCClass newClass) {
        Double rank = pc.getSkillRankForLocalClass(sk, oldClass);
        if (rank != null) {
            pc.removeSkillRankForLocalClass(sk, oldClass);
            pc.setSkillRankValue(sk, newClass, rank);
        }
    }

    private static double modRanks2(double rankChange, double curRank, PCClass pcc, PlayerCharacter aPC, Skill sk) {
        double newRank = curRank + rankChange;
        if (CoreUtility.doublesEqual(newRank, 0.0)) {
            aPC.removeSkillRankValue(sk, pcc);
        } else {
            aPC.setSkillRankValue(sk, pcc, newRank);
        }
        if (!aPC.isImporting() && ChooseActivation.hasNewChooseToken(sk) && !CoreUtility.doublesEqual(rankChange, 0.0) && !CoreUtility.doublesEqual(curRank, (int)newRank)) {
            ChooserUtilities.modChoices(sk, new ArrayList(), new ArrayList(), aPC, true, null);
            aPC.setDirty(true);
            int selectedLanguages = aPC.getSelectCorrectedAssociationCount(sk);
            int maxLanguages = SkillRankControl.getTotalRank(aPC, sk).intValue();
            if (selectedLanguages > maxLanguages) {
                newRank = curRank;
            }
        }
        aPC.calcActiveBonuses();
        return rankChange;
    }

    public static double getSkillRankBonusTo(PlayerCharacter aPC, Skill sk) {
        double bonus = aPC.getTotalBonusTo("SKILLRANK", sk.getKeyName());
        for (Type singleType : sk.getTrueTypeList(false)) {
            bonus += aPC.getTotalBonusTo("SKILLRANK", "TYPE." + singleType);
        }
        SkillRankControl.updateAdds(aPC, sk, bonus);
        return bonus;
    }

    private static void updateAdds(PlayerCharacter aPC, Skill sk, double bonus) {
        List<PersistentTransitionChoice<?>> adds = sk.getListFor(ListKey.ADD);
        if (adds != null) {
            int iCount = 0;
            for (PersistentTransitionChoice<?> ptc : adds) {
                iCount += aPC.getAssocCount(ptc, AssociationListKey.ADD);
            }
            if (CoreUtility.doublesEqual(aPC.getRank(sk).doubleValue() + bonus, 0.0)) {
                if (iCount != 0) {
                    CDOMObjectUtilities.removeAdds(sk, aPC);
                    CDOMObjectUtilities.restoreRemovals(sk, aPC);
                }
            } else if (iCount == 0) {
                CDOMObjectUtilities.addAdds(sk, aPC);
                CDOMObjectUtilities.checkRemovals(sk, aPC);
            }
        }
    }

    public static void removeSkillsForTopLevel(PlayerCharacter pc, PCClass classBeingLevelledDown, int currentLevel, int pointsToRemove) {
        double remaining = pointsToRemove;
        if (remaining <= 0.0) {
            return;
        }
        for (Skill skill : pc.getSkillSet()) {
            String err;
            if (!skill.getSafe(ObjectKey.VISIBILITY).isVisibleTo(View.VISIBLE_DISPLAY)) continue;
            PCClass pCClass = pc.getClassList().isEmpty() ? null : pc.getClassList().get(0);
            PCClass aClass = pCClass;
            double maxRanks = pc.getMaxRank(skill, aClass).doubleValue();
            double rankMod = maxRanks - (double)SkillRankControl.getTotalRank(pc, skill).floatValue();
            if (!(rankMod < 0.0)) continue;
            if (Logging.isLoggable(Logging.INFO)) {
                Logging.log(Logging.INFO, "Removing " + rankMod * -1.0 + " ranks from " + skill);
            }
            if (!StringUtils.isBlank(err = SkillRankControl.modRanks(rankMod, classBeingLevelledDown, true, pc, skill)) || !((remaining += rankMod) <= 0.0)) continue;
            break;
        }
        if (remaining != 0.0) {
            PCLevelInfo targetLevel = null;
            for (int level = currentLevel - 1; level > 0; --level) {
                PCLevelInfo pcLI = pc.getLevelInfo(level - 1);
                if (!pcLI.getClassKeyName().equals(classBeingLevelledDown.getKeyName())) continue;
                targetLevel = pcLI;
                break;
            }
            if (targetLevel == null && currentLevel > 0) {
                targetLevel = pc.getLevelInfo(currentLevel - 2);
            }
            if (targetLevel != null) {
                targetLevel.setSkillPointsRemaining(targetLevel.getSkillPointsRemaining() - (int)remaining);
            }
        }
    }
}

