/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;

public class SkillInfoUtilities {
    public static String getKeyStatFromStats(PlayerCharacter pc, Skill sk) {
        CDOMSingleRef<PCStat> stat = sk.get(ObjectKey.KEY_STAT);
        if (stat == null) {
            if (Globals.getGameModeHasPointPool()) {
                List<PCStat> statList = SkillInfoUtilities.getKeyStatList(pc, sk, null);
                StringBuilder sb = new StringBuilder(50);
                boolean needSlash = false;
                for (PCStat s : statList) {
                    if (needSlash) {
                        sb.append('/');
                    }
                    sb.append(s.getKeyName());
                }
                return sb.toString();
            }
            return "";
        }
        return stat.resolvesTo().getKeyName();
    }

    public static List<PCStat> getKeyStatList(PlayerCharacter pc, Skill sk, List<Type> typeList) {
        ArrayList<PCStat> aList = new ArrayList<PCStat>();
        if (Globals.getGameModeHasPointPool()) {
            for (Type aType : sk.getTrueTypeList(false)) {
                for (PCStat stat : pc.getDisplay().getStatSet()) {
                    List<BonusObj> bonusList = BonusUtilities.getBonusFromList(stat.getSafeListFor(ListKey.BONUS), "SKILL", "TYPE." + aType);
                    if (bonusList.size() <= 0) continue;
                    for (int iCount = bonusList.size() - 1; iCount >= 0; --iCount) {
                        aList.add(stat);
                    }
                    if (typeList == null || typeList.contains(aType)) continue;
                    typeList.add(aType);
                }
            }
        }
        return aList;
    }

    public static Iterator<Type> getSubtypeIterator(Skill sk) {
        List<Type> ret = sk.getSafeListFor(ListKey.TYPE);
        CDOMSingleRef<PCStat> keystat = sk.get(ObjectKey.KEY_STAT);
        if (keystat == null) {
            ret.remove(Type.NONE);
        } else {
            ret.remove(Type.getConstant(keystat.resolvesTo().getDisplayName()));
        }
        return ret.iterator();
    }
}

