/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.primitive;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import pcgen.cdom.base.PrimitiveCollection;

public final class PrimitiveUtilities {
    private static final Collator COLLATOR = Collator.getInstance();
    public static final Comparator<PrimitiveCollection<?>> COLLECTION_SORTER = new Comparator<PrimitiveCollection<?>>(){

        @Override
        public int compare(PrimitiveCollection<?> lstw1, PrimitiveCollection<?> lstw2) {
            return COLLATOR.compare(lstw1.getLSTformat(false), lstw2.getLSTformat(false));
        }
    };

    private PrimitiveUtilities() {
    }

    public static String joinLstFormat(Collection<? extends PrimitiveCollection<?>> pcfCollection, String separator, boolean useAny) {
        if (pcfCollection == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(pcfCollection.size() * 10);
        boolean needjoin = false;
        for (PrimitiveCollection<?> pcf : pcfCollection) {
            if (needjoin) {
                result.append(separator);
            }
            needjoin = true;
            result.append(pcf.getLSTformat(useAny));
        }
        return result.toString();
    }
}

