/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.facet.base.AbstractDataFacet;
import pcgen.core.Ability;

public class CategorizedAbilityFacet
extends AbstractDataFacet<CharID, Ability> {
    public void add(CharID id, Category<Ability> cat, Nature nat, Ability obj) {
        boolean isNew = this.ensureCachedSet(id, cat, nat);
        if (this.getCachedSet(id, cat, nat).add(obj) || isNew) {
            this.fireDataFacetChangeEvent(id, obj, 0);
        }
    }

    public void addAll(CharID id, Category<Ability> cat, Nature nature, Collection<Ability> abilities) {
        for (Ability a : abilities) {
            this.add(id, cat, nature, a);
        }
    }

    public void remove(CharID id, Category<Ability> cat, Nature nat, Ability obj) {
        Set<Ability> cached = this.getCachedSet(id, cat, nat);
        if (cached != null && cached.remove(obj)) {
            this.fireDataFacetChangeEvent(id, obj, 1);
        }
    }

    public Set<Ability> get(CharID id, Category<Ability> cat, Nature nat) {
        Set<Ability> set = this.getCachedSet(id, cat, nat);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public boolean contains(CharID id, Category<Ability> cat, Nature nat, Ability a) {
        Set<Ability> set = this.getCachedSet(id, cat, nat);
        if (set == null) {
            return false;
        }
        if (set.contains(a)) {
            return true;
        }
        for (Ability ab : set) {
            if (!ab.equals(a)) continue;
            return true;
        }
        return false;
    }

    private boolean ensureCachedSet(CharID id, Category<Ability> cat, Nature nat) {
        WrappedMapSet abilitySet;
        Map<Nature, Set<Ability>> natureMap;
        boolean isNew = false;
        Map<Category<Ability>, Map<Nature, Set<Ability>>> catMap = this.getCachedMap(id);
        if (catMap == null) {
            isNew = true;
            catMap = new HashMap<Category<Ability>, Map<Nature, Set<Ability>>>();
            this.setCache(id, catMap);
        }
        if ((natureMap = catMap.get(cat)) == null) {
            isNew = true;
            natureMap = new HashMap<Nature, Set<Ability>>();
            catMap.put(cat, natureMap);
        }
        if ((abilitySet = natureMap.get((Object)nat)) == null) {
            isNew = true;
            abilitySet = new WrappedMapSet(IdentityHashMap.class);
            natureMap.put(nat, (Set<Ability>)abilitySet);
        }
        return isNew;
    }

    private Set<Ability> getCachedSet(CharID id, Category<Ability> cat, Nature nat) {
        Map<Category<Ability>, Map<Nature, Set<Ability>>> catMap = this.getCachedMap(id);
        if (catMap == null) {
            return null;
        }
        Map<Nature, Set<Ability>> natureMap = catMap.get(cat);
        if (natureMap == null) {
            return null;
        }
        return natureMap.get((Object)nat);
    }

    private Map<Category<Ability>, Map<Nature, Set<Ability>>> getCachedMap(CharID id) {
        return (Map)this.getCache(id);
    }

    public void removeAll(CharID id) {
        Map catMap = (Map)this.removeCache(id);
        if (catMap != null) {
            for (Map.Entry catME : catMap.entrySet()) {
                Map natMap = (Map)catME.getValue();
                this.processRemoveNatureMap(id, natMap);
            }
        }
    }

    public void removeAll(CharID id, Category<Ability> cat) {
        Map<Nature, Set<Ability>> natMap;
        Map<Category<Ability>, Map<Nature, Set<Ability>>> catMap = this.getCachedMap(id);
        if (catMap != null && (natMap = catMap.remove(cat)) != null) {
            this.processRemoveNatureMap(id, natMap);
        }
    }

    public void removeAll(CharID id, Category<Ability> cat, Nature nature) {
        Set<Ability> abilitySet;
        Map<Nature, Set<Ability>> natMap;
        Map<Category<Ability>, Map<Nature, Set<Ability>>> catMap = this.getCachedMap(id);
        if (catMap != null && (natMap = catMap.remove(cat)) != null && (abilitySet = natMap.get((Object)nature)) != null) {
            this.processRemoveAbilityMap(id, abilitySet);
        }
    }

    private void processRemoveNatureMap(CharID id, Map<Nature, Set<Ability>> natMap) {
        for (Map.Entry<Nature, Set<Ability>> natME : natMap.entrySet()) {
            this.processRemoveAbilityMap(id, natME.getValue());
        }
    }

    public void removeAll(CharID id, Nature nature) {
        Map<Category<Ability>, Map<Nature, Set<Ability>>> catMap = this.getCachedMap(id);
        if (catMap != null) {
            for (Map.Entry<Category<Ability>, Map<Nature, Set<Ability>>> catME : catMap.entrySet()) {
                Set<Ability> abilitySet = catME.getValue().remove((Object)nature);
                if (abilitySet == null) continue;
                this.processRemoveAbilityMap(id, abilitySet);
            }
        }
    }

    private void processRemoveAbilityMap(CharID id, Set<Ability> abilitySet) {
        for (Ability a : abilitySet) {
            this.fireDataFacetChangeEvent(id, a, 1);
        }
    }

    public Set<Category<Ability>> getCategories(CharID id) {
        Map<Category<Ability>, Map<Nature, Set<Ability>>> map = this.getCachedMap(id);
        if (map == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(map.keySet());
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Map<Category<Ability>, Map<Nature, Set<Ability>>> map = this.getCachedMap(source);
        if (map != null) {
            for (Map.Entry<Category<Ability>, Map<Nature, Set<Ability>>> me : map.entrySet()) {
                Category<Ability> cat = me.getKey();
                for (Map.Entry<Nature, Set<Ability>> nme : me.getValue().entrySet()) {
                    Nature nat = nme.getKey();
                    this.ensureCachedSet(copy, cat, nat);
                    this.getCachedSet(copy, cat, nat).addAll((Collection<Ability>)nme.getValue());
                }
            }
        }
    }
}

