/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.base.AbstractQualifiedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.core.Equipment;
import pcgen.core.QualifiedObject;

public class AutoEquipmentFacet
extends AbstractQualifiedListFacet<QualifiedObject<CDOMReference<Equipment>>>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        List<QualifiedObject<CDOMReference<Equipment>>> list = cdo.getSafeListFor(ListKey.EQUIPMENT);
        if (list != null) {
            this.addAll(dfce.getCharID(), list, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public List<Equipment> getAutoEquipment(CharID id) {
        ArrayList<Equipment> list = new ArrayList<Equipment>();
        for (QualifiedObject qo : this.getQualifiedSet(id)) {
            Collection equipList = ((CDOMReference)qo.getRawObject()).getContainedObjects();
            for (Equipment e : equipList) {
                e = e.clone();
                e.setQty(1.0);
                e.setAutomatic(true);
                list.add(e);
            }
        }
        return list;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

