/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import plugin.network.NetworkModel;

public class NetworkClient {
    private String user = "Client";
    private NetworkModel model;
    private Socket sock;
    private BufferedReader is;
    private PrintStream os;

    public NetworkClient(NetworkModel model) {
        this.model = model;
        this.user = SettingsHandler.getGMGenOption((String)"Network.username", (String)"Player");
    }

    public void startClient() {
        String host = this.model.getView().getServerAddressTextField().getText();
        int port = SettingsHandler.getGMGenOption((String)"Network.port", (int)80);
        this.model.getView().setConnectionText("Client Status", "Attempting to connect to " + host + ":" + port);
        try {
            this.sock = new Socket(host, port);
            this.is = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8"));
            this.os = new PrintStream((OutputStream)new BufferedOutputStream(this.sock.getOutputStream()), true, "UTF-8");
            new Handler(this.is).start();
            this.sendUserMessage(this.user);
            this.model.getView().setConnectionText("Client Status", "Connected to " + host + ":" + port);
            SettingsHandler.setGMGenOption((String)"Network.ipAddress", (String)host);
            this.model.refresh();
        }
        catch (Exception e) {
            this.model.getView().setConnectionText("Server Error", e.getMessage());
            this.model.resetClient();
        }
    }

    public String getUser() {
        return this.user;
    }

    public void sendIM(String target, String text) {
        this.sendMessage("IM", target + "|" + text);
    }

    public void sendBroadcast(String message) {
        this.sendMessage("Broadcast", message);
    }

    public void sendUserMessage(String aUser) {
        this.sendMessage("User", aUser);
    }

    public void sendLogMessage(String owner, String message) {
        this.sendMessage("Log", owner + "|" + message);
    }

    public void sendExitMessage() {
        this.sendMessage("Exit", "");
    }

    public void sendPcgMessage(String uid, String message) {
        this.sendMessage("Pcg", uid + ":" + message);
    }

    private synchronized void sendMessage(String type, String message) {
        this.os.print(type + ": " + message + "\r\n");
        this.os.flush();
    }

    private void handleRemoveUserMessage(String aUser) {
        this.model.removeUser(aUser);
    }

    private void handleAddUserMessage(String aUser) {
        if (!aUser.equals(this.user)) {
            this.model.addUser(aUser);
        }
    }

    private void handlePcgMessage(String message, Socket socket) {
        int num = message.indexOf(":");
        String uid = message.substring(0, num);
        String messagetext = message.substring(num + 1);
        this.model.handleServerPcgMessage(uid, messagetext, socket);
    }

    private void handleLogMessage(String aUser, String message) {
        String owner = "";
        String log = "";
        StringTokenizer st = new StringTokenizer(message, "|");
        if (st.hasMoreTokens()) {
            owner = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            log = st.nextToken();
        }
        this.model.log(aUser, owner, log);
    }

    private void handleIMMessage(String message) {
        String aUser = "";
        String log = "";
        StringTokenizer st = new StringTokenizer(message, "|");
        if (st.hasMoreTokens()) {
            aUser = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            log = st.nextToken();
        }
        this.model.log(aUser, log);
    }

    private void handleBroadcastMessage(String message) {
        String aUser = "";
        String log = "";
        StringTokenizer st = new StringTokenizer(message, "|");
        if (st.hasMoreTokens()) {
            aUser = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            log = st.nextToken();
        }
        this.model.log(aUser, "BROADCAST", log);
    }

    private String handleMessage(String message, Socket socket) {
        String retValue = "";
        if (message.startsWith("Pcg:")) {
            this.handlePcgMessage(message.substring(5), socket);
        } else if (message.startsWith("RemoveUser:")) {
            this.handleRemoveUserMessage(message.substring(12));
        } else if (message.startsWith("AddUser:")) {
            this.handleAddUserMessage(message.substring(9));
        } else if (message.startsWith("Log:")) {
            this.handleLogMessage("Server", message.substring(5));
        } else if (message.startsWith("IM:")) {
            this.handleIMMessage(message.substring(4));
        } else if (message.startsWith("Broadcast:")) {
            this.handleBroadcastMessage(message.substring(11));
        } else if (message.startsWith("Exit:")) {
            this.sendExitMessage();
        } else {
            retValue = "Return: " + message;
        }
        return retValue;
    }

    protected class Handler
    extends Thread {
        BufferedReader inputStream;

        public Handler(BufferedReader is) {
            this.inputStream = is;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                String line;
                while ((line = this.inputStream.readLine()) != null) {
                    String retString = "";
                    Logging.debugPrint((String)("Network message from Server: " + line));
                    try {
                        retString = NetworkClient.this.handleMessage(line, NetworkClient.this.sock);
                        if (retString.equals("")) continue;
                        NetworkClient.this.os.print(retString + "\r\n");
                        NetworkClient.this.os.flush();
                    }
                    catch (Exception e) {
                        if (!e.getMessage().equals("")) {
                            NetworkClient.this.os.print("Error: " + e.getMessage());
                            NetworkClient.this.os.flush();
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                return;
            }
            NetworkClient.this.model.resetClient();
        }
    }
}

