/*
 * Decompiled with CFR 0.152.
 */
package plugin.qualifier.armorprof;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.ArmorProf;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public class EquipmentToken
implements QualifierToken<ArmorProf>,
Converter<Equipment, CDOMReference<ArmorProf>> {
    private static final Type ARMOR_TYPE = Type.getConstant((String)"Armor");
    private PrimitiveCollection<Equipment> pcs = null;
    private boolean wasRestricted = false;

    public String getTokenName() {
        return "EQUIPMENT";
    }

    public Class<ArmorProf> getReferenceClass() {
        return ArmorProf.class;
    }

    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTokenName());
        if (this.wasRestricted) {
            sb.append('[').append(this.pcs.getLSTformat(useAny)).append(']');
        }
        return sb.toString();
    }

    public boolean initialize(LoadContext context, SelectionCreator<ArmorProf> sc, String condition, String value, boolean negate) {
        if (negate) {
            Logging.addParseMessage((Level)Level.SEVERE, (String)("Cannot make " + this.getTokenName() + " into a negated Qualifier, remove !"));
            return false;
        }
        if (condition != null) {
            Logging.addParseMessage((Level)Level.SEVERE, (String)("Cannot make " + this.getTokenName() + " into a conditional Qualifier, remove ="));
            return false;
        }
        ReferenceManufacturer erm = context.getReferenceContext().getManufacturer(Equipment.class);
        if (value == null) {
            this.pcs = erm.getAllReference();
        } else {
            this.pcs = context.getPrimitiveChoiceFilter((SelectionCreator)erm, value);
            this.wasRestricted = true;
        }
        return this.pcs != null;
    }

    public int hashCode() {
        return this.pcs == null ? 0 : this.pcs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof EquipmentToken) {
            EquipmentToken other = (EquipmentToken)o;
            if (this.pcs == null) {
                return other.pcs == null;
            }
            return this.pcs.equals(other.pcs);
        }
        return false;
    }

    public GroupingState getGroupingState() {
        return this.pcs == null ? GroupingState.ANY : this.pcs.getGroupingState().reduce();
    }

    public <R> Collection<R> getCollection(PlayerCharacter pc, Converter<ArmorProf, R> c) {
        HashSet returnSet = new HashSet();
        Collection intermediate = this.pcs.getCollection(pc, (Converter)this);
        for (ObjectContainer ref : intermediate) {
            returnSet.addAll(c.convert(ref));
        }
        return returnSet;
    }

    public Collection<CDOMReference<ArmorProf>> convert(ObjectContainer<Equipment> orig) {
        HashSet<CDOMReference<ArmorProf>> refSet = new HashSet<CDOMReference<ArmorProf>>();
        for (Equipment e : orig.getContainedObjects()) {
            CDOMSingleRef prof;
            if (!e.getListFor(ListKey.TYPE).contains(ARMOR_TYPE) || (prof = (CDOMSingleRef)e.get(ObjectKey.ARMOR_PROF)) == null) continue;
            refSet.add((CDOMReference<ArmorProf>)prof);
        }
        return refSet;
    }

    public Collection<CDOMReference<ArmorProf>> convert(ObjectContainer<Equipment> orig, PrimitiveFilter<Equipment> lim) {
        throw new UnsupportedOperationException("Only EquipmentToken should call itself as a Converter");
    }
}

