/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\f\u0010\u0015\u001a\u00020\u000b*\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "lowerConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irConstructor", "shouldInitializeOuterThis", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nInnerClassesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InnerClassesLowering.kt\norg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1761#2,3:309\n1#3:312\n*S KotlinDebug\n*F\n+ 1 InnerClassesLowering.kt\norg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering\n*L\n111#1:309,3\n*E\n"})
public class InnerClassesLowering
implements DeclarationTransformer {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final InnerClassesSupport innerClassesSupport;

    public InnerClassesLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.innerClassesSupport = this.context.getInnerClassesSupport();
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof IrClass && ((IrClass)declaration).isInner()) {
            ((Collection)((IrClass)declaration).getDeclarations()).add(this.innerClassesSupport.getOuterThisField((IrClass)declaration));
        } else if (declaration instanceof IrConstructor) {
            IrClass irClass = IrUtilsKt.getParentAsClass(declaration);
            if (!irClass.isInner()) {
                return null;
            }
            IrConstructor newConstructor = this.lowerConstructor((IrConstructor)declaration);
            Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this.innerClassesSupport, (IrConstructor)declaration);
            VariableRemapper variableRemapper = new VariableRemapper(oldConstructorParameterToNew);
            for (Map.Entry entry : oldConstructorParameterToNew.entrySet()) {
                IrExpressionBody irExpressionBody;
                IrValueParameter newParam;
                IrValueParameter oldParam = (IrValueParameter)entry.getKey();
                IrValueParameter irValueParameter = newParam = (IrValueParameter)entry.getValue();
                if (oldParam.getDefaultValue() != null) {
                    void oldDefault;
                    IrValueParameter irValueParameter2 = irValueParameter;
                    boolean bl = false;
                    irExpressionBody = this.context.getIrFactory().createExpressionBody(oldDefault.getStartOffset(), oldDefault.getEndOffset(), (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents(oldDefault.getExpression().transform((IrTransformer)variableRemapper, (Object)null), newConstructor));
                    irValueParameter = irValueParameter2;
                } else {
                    irExpressionBody = null;
                }
                irValueParameter.setDefaultValue(irExpressionBody);
            }
            return CollectionsKt.listOf(newConstructor);
        }
        return null;
    }

    private final IrConstructor lowerConstructor(IrConstructor irConstructor) {
        IrConstructor loweredConstructor;
        block1: {
            loweredConstructor = this.innerClassesSupport.getInnerClassConstructorWithOuterThisParameter(irConstructor);
            IrValueParameter outerThisParameter = loweredConstructor.getParameters().get(0);
            IrClass irClass = IrUtilsKt.getParentAsClass(irConstructor);
            IrField parentThisField = this.innerClassesSupport.getOuterThisField(irClass);
            IrBody irBody = irConstructor.getBody();
            if (irBody == null) break block1;
            IrBody blockBody = irBody;
            boolean bl = false;
            if (!(blockBody instanceof IrBlockBody)) {
                throw new AssertionError((Object)("Unexpected constructor body: " + irConstructor.getBody()));
            }
            loweredConstructor.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), blockBody.getStartOffset(), blockBody.getEndOffset(), arg_0 -> InnerClassesLowering.lowerConstructor$lambda$0$0(this, irConstructor, blockBody, loweredConstructor, irClass, parentThisField, outerThisParameter, arg_0)));
        }
        return loweredConstructor;
    }

    private final boolean shouldInitializeOuterThis(IrConstructor $this$shouldInitializeOuterThis) {
        boolean bl;
        block4: {
            IrBody irBody = $this$shouldInitializeOuterThis.getBody();
            IrBlockBody irBlockBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
            if (irBlockBody == null) {
                return false;
            }
            IrBlockBody irBlockBody2 = irBlockBody;
            Iterable $this$any$iv = irBlockBody2.getStatements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrInstanceInitializerCall)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Unit lowerConstructor$lambda$0$0(InnerClassesLowering this$0, IrConstructor $irConstructor, IrBody $blockBody, IrConstructor $loweredConstructor, IrClass $irClass, IrField $parentThisField, IrValueParameter $outerThisParameter, IrBlockBody $this$createBlockBody) {
        Object object;
        Object object2;
        Object object3;
        block5: {
            Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
            if (this$0.shouldInitializeOuterThis($irConstructor)) {
                DeclarationIrBuilder declarationIrBuilder;
                DeclarationIrBuilder $this$lowerConstructor_u24lambda_u240_u240_u240 = declarationIrBuilder = LowerUtilsKt.createIrBuilder(this$0.context, (IrSymbol)$irConstructor.getSymbol(), $irConstructor.getStartOffset(), $irConstructor.getEndOffset());
                boolean bl = false;
                List<IrStatement> list = $this$createBlockBody.getStatements();
                IrBuilder irBuilder = $this$lowerConstructor_u24lambda_u240_u240_u240;
                IrBuilder irBuilder2 = $this$lowerConstructor_u24lambda_u240_u240_u240;
                IrValueParameter irValueParameter = $irClass.getThisReceiver();
                Intrinsics.checkNotNull(irValueParameter);
                list.add(0, ExpressionHelpersKt.irSetField$default(irBuilder, ExpressionHelpersKt.irGet(irBuilder2, irValueParameter), $parentThisField, ExpressionHelpersKt.irGet($this$lowerConstructor_u24lambda_u240_u240_u240, $outerThisParameter), null, 8, null));
            }
            $this$createBlockBody.getStatements().addAll((Collection<IrStatement>)((IrBlockBody)$blockBody).getStatements());
            object3 = $this$createBlockBody.getStatements();
            Iterator bl = object3.iterator();
            while (bl.hasNext()) {
                object2 = bl.next();
                IrStatement it = (IrStatement)object2;
                boolean bl2 = false;
                if (!(it instanceof IrInstanceInitializerCall)) continue;
                object = object2;
                break block5;
            }
            object = null;
        }
        if (object == null) {
            Object v5;
            block6: {
                object2 = $this$createBlockBody.getStatements();
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Object t2 = iterator2.next();
                    IrStatement it = (IrStatement)t2;
                    boolean bl = false;
                    if (!(it instanceof IrDelegatingConstructorCall)) continue;
                    v5 = t2;
                    break block6;
                }
                v5 = null;
            }
            IrDelegatingConstructorCall irDelegatingConstructorCall = v5;
            if (irDelegatingConstructorCall == null) {
                throw new AssertionError((Object)("Delegating constructor call expected: " + DumpIrTreeKt.dump$default($irConstructor, null, 1, null)));
            }
            IrDelegatingConstructorCall delegatingConstructorCall = irDelegatingConstructorCall;
            Object $this$lowerConstructor_u24lambda_u240_u240_u243 = object3 = delegatingConstructorCall;
            boolean bl = false;
            ((IrMemberAccessExpression)$this$lowerConstructor_u24lambda_u240_u240_u243).setDispatchReceiver(BuildersKt.IrGetValueImpl$default($this$lowerConstructor_u24lambda_u240_u240_u243.getStartOffset(), $this$lowerConstructor_u24lambda_u240_u240_u243.getEndOffset(), $outerThisParameter.getSymbol(), null, 8, null));
        }
        PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$this$createBlockBody, $loweredConstructor);
        Map oldConstructorParameterToNew = InnerClassesLoweringKt.access$primaryConstructorParameterMap(this$0.innerClassesSupport, $irConstructor);
        IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new VariableRemapper(oldConstructorParameterToNew));
        return Unit.INSTANCE;
    }
}

