/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles.internal;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.fluent.tiles.Tile;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HubSectionLayouter {
    private final boolean[][] occupied;
    private final Map<Tile, Point> tileToOrigins;
    private final int givenWidth;
    private final boolean layoutKeepsTileOrder;
    private int gridWidth;
    private int gridHeight;

    public HubSectionLayouter(int givenWidth, int tileCount, boolean layoutKeepsTileOrder) {
        this.givenWidth = givenWidth;
        this.layoutKeepsTileOrder = layoutKeepsTileOrder;
        this.gridWidth = 0;
        this.gridHeight = 0;
        int largeTilesPerGridSize = Math.max(1, givenWidth / 4);
        int maxGridExtent = layoutKeepsTileOrder ? 4 * tileCount : 4 * (1 + (tileCount - 1) / largeTilesPerGridSize);
        int arrayWidth = givenWidth;
        int arrayHeight = maxGridExtent;
        this.occupied = new boolean[arrayWidth][arrayHeight];
        this.tileToOrigins = new HashMap<Tile, Point>();
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public Point getOrigin(Tile tile) {
        return this.tileToOrigins.get(tile);
    }

    public Map<Tile, Point> findOrigins(List<Tile> tiles) {
        for (Tile tile : tiles) {
            Tile.Size tileSize = tile.getSize();
            int tileWidth = tileSize.getWidth();
            int tileHeight = tileSize.getHeight();
            Preconditions.checkArgument(tileWidth <= this.givenWidth, "The hub section width %1$s must be >= %2$s to contain tile %3$s", this.givenWidth, tileWidth, tile);
            Point origin = this.findOrigin(tileWidth, tileHeight);
            int lowerRightX = origin.x + tileWidth;
            int lowerRightY = origin.y + tileHeight;
            if (this.layoutKeepsTileOrder) {
                this.setOccupied(0, 0, lowerRightX, lowerRightY);
            } else {
                this.setOccupied(origin.x, origin.y, lowerRightX, lowerRightY);
            }
            this.tileToOrigins.put(tile, origin);
            this.gridWidth = Math.max(this.gridWidth, lowerRightX);
            this.gridHeight = Math.max(this.gridHeight, lowerRightY);
        }
        return this.tileToOrigins;
    }

    private Point findOrigin(int tileWidth, int tileHeight) {
        int originY = 0;
        int originX = 0;
        int firstUnoccupied;
        while ((firstUnoccupied = this.findFirstUnoccupied(originX, originY, tileWidth, tileHeight)) != -1) {
            int advance = firstUnoccupied + 1;
            if ((originX += advance) <= this.givenWidth - tileWidth) continue;
            originX = 0;
            ++originY;
        }
        return new Point(originX, originY);
    }

    private int findFirstUnoccupied(int originX, int originY, int tileWidth, int tileHeight) {
        for (int y = 0; y <= tileHeight - 1; ++y) {
            for (int x = tileWidth - 1; x >= 0; --x) {
                if (!this.occupied[originX + x][originY + y]) continue;
                return x;
            }
        }
        return -1;
    }

    private void setOccupied(int upperLeftX, int upperLeftY, int lowerRightX, int lowerRightY) {
        for (int y = upperLeftY; y < lowerRightY; ++y) {
            for (int x = upperLeftX; x < lowerRightX; ++x) {
                this.occupied[x][y] = true;
            }
        }
    }
}

