/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.fluent.internal.Releasable;
import com.jgoodies.fluent.tiles.CustomTile;
import com.jgoodies.fluent.tiles.CustomTileView;
import com.jgoodies.fluent.tiles.HubSection;
import com.jgoodies.fluent.tiles.HubView;
import com.jgoodies.fluent.tiles.ObjectTile;
import com.jgoodies.fluent.tiles.ObjectTileView;
import com.jgoodies.fluent.tiles.Tile;
import com.jgoodies.fluent.tiles.TileToViewRegistry;
import com.jgoodies.fluent.tiles.internal.HubSectionLayouter;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.navigation.views.View;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class HubSectionView
implements Releasable {
    private final HubView hubView;
    private final HubSection section;
    private final int sectionSize;
    private final int effectiveBaseTileSize;
    private final JGComponentFactory factory;
    private final List<View> views = new ArrayList<View>();

    public HubSectionView(HubView hubView, HubSection section, int effectiveBaseTileSize) {
        this.hubView = hubView;
        this.section = Preconditions.checkNotNull(section, "The %s must not be null.", "section");
        this.sectionSize = section.getWidth();
        this.effectiveBaseTileSize = effectiveBaseTileSize;
        this.factory = JGComponentFactory.getCurrent();
    }

    public HubSection getHubSection() {
        return this.section;
    }

    @Override
    public void release() {
        for (View view : this.views) {
            if (!(view instanceof Releasable)) continue;
            ((Releasable)((Object)view)).release();
        }
        this.views.clear();
    }

    public JComponent buildPanel() {
        this.release();
        HubSectionLayouter layouter = new HubSectionLayouter(this.sectionSize, this.section.getTiles().size(), this.section.getLayoutKeepsTileOrder());
        layouter.findOrigins(this.section.getTiles());
        JComponent sectionHeader = this.createSectionHeader(this.section.getHeader());
        if (layouter.getGridWidth() == 0 || layouter.getGridHeight() == 0) {
            return sectionHeader;
        }
        FormBuilder builder = (FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("%1$s*(f:%2$sepx, 4epx), f:%2$sepx", layouter.getGridWidth() - 1, this.effectiveBaseTileSize)).rows("p, 12epx, %1$s*(f:%2$sepx, 4epx), f:%2$sepx", layouter.getGridHeight() - 1, this.effectiveBaseTileSize)).add(sectionHeader).xyw(1, 1, 2 * layouter.getGridWidth() - 1);
        for (Tile tile : this.section.getTiles()) {
            Point origin = layouter.getOrigin(tile);
            int x = origin.x + 1;
            int y = origin.y + 1;
            int w = tile.getSize().getWidth();
            int h = tile.getSize().getHeight();
            View view = TileToViewRegistry.createView(tile);
            if (view == null) continue;
            builder.add(view.getPanel()).xywh(x * 2 - 1, 2 + y * 2 - 1, w * 2 - 1, h * 2 - 1);
            this.views.add(view);
        }
        return builder.build();
    }

    private void onSectionHeaderContextMenu(MouseEvent evt) {
        if (this.getHubSection().getOnHeaderContextMenu() != null) {
            this.getHubSection().getOnHeaderContextMenu().accept(evt);
        }
    }

    private JComponent createSectionHeader(String text) {
        JLabel label = this.factory.createLabel(text);
        label.setFont(this.hubView.getSectionHeaderFont());
        label.setForeground(this.hubView.getTheme().foreground());
        label.addMouseListener(Listeners.contextMenu(this::onSectionHeaderContextMenu));
        return label;
    }

    static {
        TileToViewRegistry.register(ObjectTile.class, ObjectTileView::new);
        TileToViewRegistry.register(CustomTile.class, CustomTileView::new);
    }
}

