/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import groovy.lang.GString;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.condition.EditDistance;
import org.spockframework.runtime.condition.EditPathRenderer;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.util.ObjectUtil;

public class ExpressionInfoValueRenderer {
    private final ExpressionInfo expr;

    private ExpressionInfoValueRenderer(ExpressionInfo expr) {
        this.expr = expr;
    }

    public static void render(ExpressionInfo expr) {
        new ExpressionInfoValueRenderer(expr).render();
    }

    private void render() {
        for (ExpressionInfo expr : this.expr.inPostfixOrder(true)) {
            expr.setRenderedValue(this.renderValue(expr));
        }
    }

    private String renderValue(ExpressionInfo expr) {
        int index;
        String text;
        String potentialEnumConstantNameInText;
        String str;
        Object value = expr.getValue();
        if (value == null) {
            return "null";
        }
        if ("".equals(value)) {
            return "\"\"";
        }
        try {
            str = this.doRenderValue(expr);
        }
        catch (Exception e) {
            return String.format("%s (renderer threw %s)", this.javaLangObjectToString(value), e.getClass().getSimpleName());
        }
        if (str == null || str.equals("")) {
            return this.javaLangObjectToString(value);
        }
        if (value instanceof Enum && str.equals(potentialEnumConstantNameInText = (text = expr.getText().trim()).substring((index = text.lastIndexOf(46)) + 1))) {
            return null;
        }
        return str;
    }

    private String javaLangObjectToString(Object value) {
        String hash = Integer.toHexString(System.identityHashCode(value));
        return value.getClass().getName() + "@" + hash;
    }

    private String doRenderValue(ExpressionInfo expr) {
        String result = this.renderAsFailedStringComparison(expr);
        if (result != null) {
            return result;
        }
        result = this.renderAsFailedEqualityComparison(expr);
        if (result != null) {
            return result;
        }
        return GroovyRuntimeUtil.toString(expr.getValue());
    }

    private String renderAsFailedStringComparison(ExpressionInfo expr) {
        if (!Boolean.FALSE.equals(expr.getValue())) {
            return null;
        }
        if (!expr.isEqualityComparison(String.class, GString.class)) {
            return null;
        }
        String str1 = expr.getChildren().get(0).getValue().toString();
        String str2 = expr.getChildren().get(1).getValue().toString();
        EditDistance dist = new EditDistance(str1, str2);
        return String.format("false\n%d difference%s (%d%% similarity)\n%s", dist.getDistance(), dist.getDistance() == 1 ? "" : "s", dist.getSimilarityInPercent(), new EditPathRenderer().render(str1, str2, dist.calculatePath()));
    }

    private String renderAsFailedEqualityComparison(ExpressionInfo expr) {
        if (!Boolean.FALSE.equals(expr.getValue())) {
            return null;
        }
        if (!expr.isEqualityComparison()) {
            return null;
        }
        ExpressionInfo expr1 = expr.getChildren().get(0);
        ExpressionInfo expr2 = expr.getChildren().get(1);
        if (expr1.getEffectiveRenderedValue().equals(expr2.getEffectiveRenderedValue())) {
            this.addTypeHint(expr1);
            this.addTypeHint(expr2);
        }
        return "false";
    }

    private void addTypeHint(ExpressionInfo expr) {
        if (expr.getRenderedValue() == null) {
            return;
        }
        Class<?> exprType = ObjectUtil.voidAwareGetClass(expr.getValue());
        expr.setRenderedValue(expr.getRenderedValue() + " (" + exprType.getName() + ")");
    }
}

