/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.Explanation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class Authorizations {
    private Authorizations() {
    }

    public static Authorization append(Authorization auth, Authorization auth2) {
        return new MultiAuth(auth, auth2);
    }

    static class MultiAuth
    implements Authorization {
        private final Authorization auth1;
        private final Authorization auth2;

        public MultiAuth(Authorization auth1, Authorization auth2) {
            this.auth1 = auth1;
            this.auth2 = auth2;
        }

        static int codeOrdinal(Explanation.Code code) {
            if (code == Explanation.Code.REJECTED_DENIED) {
                return -1;
            }
            return code.ordinal();
        }

        @Override
        public Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
            Decision decision1 = this.auth1.evaluate(resource, subject, action, environment);
            Decision decision2 = this.auth2.evaluate(resource, subject, action, environment);
            return this.prioritize(decision1, decision2);
        }

        public Decision prioritize(Decision decision1, Decision decision2) {
            int d2;
            int d1 = MultiAuth.codeOrdinal(decision1.explain().getCode());
            if (d1 < (d2 = MultiAuth.codeOrdinal(decision2.explain().getCode()))) {
                return decision1;
            }
            if (d2 < d1) {
                return decision2;
            }
            return decision1;
        }

        @Override
        public Set<Decision> evaluate(Set<Map<String, String>> resources, Subject subject, Set<String> actions, Set<Attribute> environment) {
            Set<Decision> set1 = this.auth1.evaluate(resources, subject, actions, environment);
            Set<Decision> set2 = this.auth2.evaluate(resources, subject, actions, environment);
            HashSet<Decision> results = new HashSet<Decision>();
            for (Decision d1 : set1) {
                boolean found = false;
                for (Decision d2 : set2) {
                    if (!d1.getResource().equals(d2.getResource()) || !d1.getAction().equals(d2.getAction())) continue;
                    results.add(this.prioritize(d2, d1));
                    found = true;
                    break;
                }
                if (found) continue;
            }
            return results;
        }
    }
}

