/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.TagInfo;
import megamek.common.ToHitData;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.ArtilleryWeaponIndirectFireHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtilleryWeaponIndirectHomingHandler
extends ArtilleryWeaponIndirectFireHandler
implements Serializable {
    private static final long serialVersionUID = -7243477723032010917L;

    public ArtilleryWeaponIndirectHomingHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        Object object;
        Serializable serializable;
        boolean bl;
        Entity entity;
        if (!this.cares(phase)) {
            return true;
        }
        ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)this.waa;
        if (phase == IGame.Phase.PHASE_TARGETING) {
            if (!this.handledAmmoAndReport) {
                this.addHeat();
                this.r = new Report(3121);
                this.r.indent();
                this.r.newlines = 0;
                this.r.subject = this.subjectId;
                this.r.add(this.wtype.getName());
                this.r.add(artilleryAttackAction.turnsTilHit);
                vector.addElement(this.r);
                Report.addNewline(vector);
                this.handledAmmoAndReport = true;
            }
            if (artilleryAttackAction.turnsTilHit == 0) {
                this.announcedEntityFiring = false;
            }
            return true;
        }
        if (artilleryAttackAction.turnsTilHit > 0) {
            --artilleryAttackAction.turnsTilHit;
            return true;
        }
        if (this.game.getPhase() == IGame.Phase.PHASE_OFFBOARD) {
            this.convertHomingShotToEntityTarget();
            entity = artilleryAttackAction.getTargetType() == 0 ? (Entity)artilleryAttackAction.getTarget(this.game) : null;
        } else {
            entity = (Entity)this.target;
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity);
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        if (entity != null) {
            this.r.addDesc(entity);
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl3 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("tacops_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        this.toHit.setMoS(this.roll - Math.max(2, this.toHit.getValue()));
        boolean bl4 = this.bDirect = this.game.getOptions().booleanOption("tacops_direct_blow") && this.toHit.getMoS() / 3 >= 1 && entity != null;
        if (this.bDirect) {
            this.r = new Report(3189);
            this.r.subject = this.ae.getId();
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if (!this.handledAmmoAndReport) {
            this.addHeat();
        }
        if (bl = this.doChecks(vector)) {
            this.bMissed = true;
        }
        this.nDamPerHit = this.wtype.getRackSize();
        if (((AmmoType)this.ammo.getType()).getAmmoType() != 15) {
            this.nDamPerHit -= 10;
        }
        if (this.specialResolution(vector, entity, this.bMissed)) {
            return false;
        }
        if (this.bMissed && !bl) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl2, building, vector)) {
                return false;
            }
        }
        int n = 1;
        int n2 = 1;
        if (entity != null && entity.getTaggedBy() != -1 && artilleryAttackAction.getCoords() != null) {
            this.toHit.setSideTable(entity.sideTable(artilleryAttackAction.getCoords()));
        }
        int n3 = 0;
        if (bl2 && building != null) {
            n3 = (int)Math.ceil((double)building.getPhaseCF(this.target.getPosition()) / 10.0);
        }
        if (building != null && n3 > 0) {
            this.r = new Report(6010);
            if (entity != null) {
                this.r.subject = entity.getId();
            }
            this.r.add(n3);
            vector.addElement(this.r);
            serializable = this.server.damageBuilding(building, this.nDamPerHit, entity.getPosition());
            Iterator iterator = ((Vector)serializable).iterator();
            while (iterator.hasNext()) {
                object = (Report)iterator.next();
                ((Report)object).subject = entity.getId();
            }
            vector.addAll((Collection<Report>)((Object)serializable));
        }
        this.nDamPerHit -= n3;
        if (this.nDamPerHit == 0) {
            this.r = new Report(3365);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
            return false;
        }
        if (!this.bMissed && entity != null) {
            this.handleEntityDamage(entity, vector, building, n, n2, this.nDamPerHit, n3);
            this.server.creditKill(entity, this.ae);
        }
        serializable = this.target.getPosition();
        int n4 = 5;
        building = null;
        building = this.game.getBoard().getBuildingAt((Coords)serializable);
        n3 = building != null ? building.getPhaseCF((Coords)serializable) / 10 : 0;
        n3 = Math.min(n3, n4);
        this.handleClearDamage(vector, building, n4 * 2, this.bSalvo);
        if ((n4 -= n3) > 0) {
            object = this.game.getEntities((Coords)serializable);
            while (object.hasMoreElements()) {
                Entity entity2 = (Entity)object.nextElement();
                if (!this.bMissed && entity2 == entity) continue;
                this.toHit.setSideTable(entity2.sideTable(artilleryAttackAction.getCoords()));
                HitData hitData = entity2.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
                vector.addAll(this.server.damageEntity(entity2, hitData, n4, false, Server.DamageType.NONE, false, true, this.throughFront, this.underWater));
                this.server.creditKill(entity2, this.ae);
            }
        }
        Report.addNewline(vector);
        return false;
    }

    protected void convertHomingShotToEntityTarget() {
        ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)this.waa;
        Coords coords = this.target.getPosition();
        Entity entity = null;
        TagInfo tagInfo = null;
        Entity entity2 = null;
        for (int i = 0; i < 2; ++i) {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            Vector<TagInfo> vector = this.game.getTagInfo();
            for (int j = 0; j < vector.size(); ++j) {
                tagInfo = vector.elementAt(j);
                entity2 = this.game.getEntity(tagInfo.attackerId);
                if (tagInfo.shots >= tagInfo.priority || this.ae.isEnemyOf(entity2) || (entity = this.game.getEntity(tagInfo.targetId)) == null || !entity.isOnSameSheet(coords) || coords.distance(entity.getPosition()) >= n) continue;
                n2 = j;
                n = coords.distance(entity.getPosition());
                if (!this.game.getOptions().booleanOption("a4homing_target_area")) break;
            }
            if (n2 != -1) {
                tagInfo = vector.elementAt(n2);
                entity = this.game.getEntity(tagInfo.targetId);
                entity2 = this.game.getEntity(tagInfo.attackerId);
                ++tagInfo.shots;
                this.game.updateTagInfo(tagInfo, n2);
                break;
            }
            entity = null;
            this.game.clearTagInfoShots(this.ae, coords);
        }
        if (entity == null || tagInfo == null) {
            this.toHit = new ToHitData(Integer.MAX_VALUE, "no targets tagged on map sheet");
        } else if (tagInfo.missed) {
            artilleryAttackAction.setTargetId(entity.getId());
            artilleryAttackAction.setTargetType(0);
            this.target = entity;
            this.toHit = new ToHitData(Integer.MAX_VALUE, "tag missed the target");
        } else {
            this.target = entity;
            artilleryAttackAction.setTargetId(entity.getId());
            artilleryAttackAction.setTargetType(0);
        }
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        return true;
    }
}

