/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AR10Handler;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.CapitalMissileWeapon;
import megamek.common.weapons.SantaAnnaHandler;
import megamek.common.weapons.TeleMissileHandler;
import megamek.server.Server;

public class AR10Weapon
extends CapitalMissileWeapon {
    private static final long serialVersionUID = 8756042527483383101L;

    public AR10Weapon() {
        this.techLevel = 1;
        this.name = "AR10";
        this.setInternalName(this.name);
        this.addLookupName("AR10");
        this.heat = 10;
        this.damage = -2;
        this.ammoType = 61;
        this.shortRange = 20;
        this.mediumRange = 30;
        this.longRange = 40;
        this.extremeRange = 50;
        this.tonnage = 250.0f;
        this.bv = 961.0;
        this.cost = 250000.0;
        this.shortAV = 2.0;
        this.medAV = 2.0;
        this.longAV = 2.0;
        this.extAV = 2.0;
        this.maxRange = 4;
        this.atClass = 20;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.hasFlag(512L)) {
            return new SantaAnnaHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.hasFlag(1024L)) {
            return new TeleMissileHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new AR10Handler(toHitData, weaponAttackAction, iGame, server);
    }
}

