/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.Messages;
import megamek.common.PlanetaryConditions;

public class PlanetaryConditionsDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = -4426594323169113468L;
    private ClientGUI client;
    private PlanetaryConditions conditions;
    private Label labLight = new Label(Messages.getString("PlanetaryConditionsDialog.labLight"), 2);
    private Choice choLight = new Choice();
    private Label labWeather = new Label(Messages.getString("PlanetaryConditionsDialog.labWeather"), 2);
    private Choice choWeather = new Choice();
    private Label labWind = new Label(Messages.getString("PlanetaryConditionsDialog.labWind"), 2);
    private Choice choWind = new Choice();
    private Label labAtmosphere = new Label(Messages.getString("PlanetaryConditionsDialog.labAtmosphere"), 2);
    private Choice choAtmosphere = new Choice();
    private Label labFog = new Label(Messages.getString("PlanetaryConditionsDialog.labFog"), 2);
    private Choice choFog = new Choice();
    private Checkbox cBlowingSands = new Checkbox(Messages.getString("PlanetaryConditionsDialog.BlowingSands"));
    private Checkbox cShiftWindDir = new Checkbox(Messages.getString("PlanetaryConditionsDialog.shiftWindDir"));
    private Checkbox cShiftWindStr = new Checkbox(Messages.getString("PlanetaryConditionsDialog.shiftWindStr"));
    private Label labTemp = new Label(Messages.getString("PlanetaryConditionsDialog.labTemp"), 2);
    private TextField fldTemp = new TextField(4);
    private Label labGrav = new Label(Messages.getString("PlanetaryConditionsDialog.labGrav"), 2);
    private TextField fldGrav = new TextField(4);
    private Checkbox cEMI = new Checkbox(Messages.getString("PlanetaryConditionsDialog.EMI"));
    private Checkbox cTerrainAffected = new Checkbox(Messages.getString("PlanetaryConditionsDialog.TerrainAffected"));
    private Panel panButtons = new Panel();
    private Button butOkay = new Button(Messages.getString("Okay"));
    private Button butCancel = new Button(Messages.getString("Cancel"));
    private Panel panOptions = new Panel();

    private void init(Frame frame, PlanetaryConditions planetaryConditions) {
        this.conditions = (PlanetaryConditions)planetaryConditions.clone();
        this.setupConditions();
        this.setupButtons();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.panOptions, gridBagConstraints);
        this.add(this.panOptions);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlanetaryConditionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setSize(this.getSize().width, Math.max(this.getSize().height, 400));
        this.setResizable(true);
        this.setLocation(frame.getLocation().x + frame.getSize().width / 2 - this.getSize().width / 2, frame.getLocation().y + frame.getSize().height / 2 - this.getSize().height / 2);
    }

    public PlanetaryConditionsDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("PlanetaryConditionsDialog.title"), true);
        this.client = clientGUI;
        this.init(clientGUI.frame, clientGUI.getClient().game.getPlanetaryConditions());
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    private void setupConditions() {
        this.refreshConditions();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panOptions.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labTemp, gridBagConstraints);
        this.panOptions.add(this.labTemp);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldTemp, gridBagConstraints);
        this.panOptions.add(this.fldTemp);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labLight, gridBagConstraints);
        this.panOptions.add(this.labLight);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choLight, gridBagConstraints);
        this.panOptions.add(this.choLight);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labWeather, gridBagConstraints);
        this.panOptions.add(this.labWeather);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choWeather, gridBagConstraints);
        this.panOptions.add(this.choWeather);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labWind, gridBagConstraints);
        this.panOptions.add(this.labWind);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choWind, gridBagConstraints);
        this.panOptions.add(this.choWind);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labAtmosphere, gridBagConstraints);
        this.panOptions.add(this.labAtmosphere);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choAtmosphere, gridBagConstraints);
        this.panOptions.add(this.choAtmosphere);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labFog, gridBagConstraints);
        this.panOptions.add(this.labFog);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.choFog, gridBagConstraints);
        this.panOptions.add(this.choFog);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cBlowingSands, gridBagConstraints);
        this.panOptions.add(this.cBlowingSands);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cShiftWindDir, gridBagConstraints);
        this.panOptions.add(this.cShiftWindDir);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cShiftWindStr, gridBagConstraints);
        this.panOptions.add(this.cShiftWindStr);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labGrav, gridBagConstraints);
        this.panOptions.add(this.labGrav);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fldGrav, gridBagConstraints);
        this.panOptions.add(this.fldGrav);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cEMI, gridBagConstraints);
        this.panOptions.add(this.cEMI);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cTerrainAffected, gridBagConstraints);
        this.panOptions.add(this.cTerrainAffected);
    }

    public void update(PlanetaryConditions planetaryConditions) {
        this.conditions = (PlanetaryConditions)planetaryConditions.clone();
        this.refreshConditions();
    }

    private void refreshConditions() {
        int n;
        this.choLight.removeAll();
        for (n = 0; n < PlanetaryConditions.L_SIZE; ++n) {
            this.choLight.add(PlanetaryConditions.getLightDisplayableName(n));
        }
        this.choLight.select(this.conditions.getLight());
        this.choWeather.removeAll();
        for (n = 0; n < PlanetaryConditions.WE_SIZE; ++n) {
            this.choWeather.add(PlanetaryConditions.getWeatherDisplayableName(n));
        }
        this.choWeather.select(this.conditions.getWeather());
        this.choWind.removeAll();
        for (n = 0; n < PlanetaryConditions.WI_SIZE; ++n) {
            this.choWind.add(PlanetaryConditions.getWindDisplayableName(n));
        }
        this.choWind.select(this.conditions.getWindStrength());
        this.choAtmosphere.removeAll();
        for (n = 0; n < PlanetaryConditions.ATMO_SIZE; ++n) {
            this.choAtmosphere.add(PlanetaryConditions.getAtmosphereDisplayableName(n));
        }
        this.choAtmosphere.select(this.conditions.getAtmosphere());
        this.choFog.removeAll();
        for (n = 0; n < PlanetaryConditions.FOG_SIZE; ++n) {
            this.choFog.add(PlanetaryConditions.getFogDisplayableName(n));
        }
        this.choFog.select(this.conditions.getFog());
        this.cBlowingSands.setState(this.conditions.isSandBlowing());
        this.cShiftWindDir.setState(this.conditions.shiftingWindDirection());
        this.cShiftWindStr.setState(this.conditions.shiftingWindStrength());
        this.fldTemp.setText(Integer.toString(this.conditions.getTemperature()));
        this.fldGrav.setText(Float.toString(this.conditions.getGravity()));
        this.cEMI.setState(this.conditions.hasEMI());
        this.cTerrainAffected.setState(this.conditions.isTerrainAffected());
    }

    public void send() {
        this.conditions.setLight(this.choLight.getSelectedIndex());
        this.conditions.setWeather(this.choWeather.getSelectedIndex());
        this.conditions.setWindStrength(this.choWind.getSelectedIndex());
        this.conditions.setAtmosphere(this.choAtmosphere.getSelectedIndex());
        this.conditions.setFog(this.choFog.getSelectedIndex());
        this.conditions.setBlowingSand(this.cBlowingSands.getState());
        this.conditions.setShiftingWindDirection(this.cShiftWindDir.getState());
        this.conditions.setShiftingWindStrength(this.cShiftWindStr.getState());
        this.conditions.setTemperature(Integer.parseInt(this.fldTemp.getText()));
        this.conditions.setGravity(Float.parseFloat(this.fldGrav.getText()));
        this.conditions.setEMI(this.cEMI.getState());
        this.conditions.setTerrainAffected(this.cTerrainAffected.getState());
        this.client.getClient().sendPlanetaryConditions(this.conditions);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOkay) {
            int n = 25;
            float f = 1.0f;
            try {
                n = Integer.parseInt(this.fldTemp.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new AlertDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), Messages.getString("PlanetaryConditionsDialog.EnterValidTemperature")).setVisible(true);
                return;
            }
            try {
                f = Float.parseFloat(this.fldGrav.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new AlertDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), Messages.getString("PlanetaryConditionsDialog.EnterValidGravity")).setVisible(true);
                return;
            }
            if (n > 200 || n < -200) {
                new AlertDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), Messages.getString("PlanetaryConditionsDialog.EnterValidTemperature")).setVisible(true);
                return;
            }
            if ((double)f < 0.1 || (double)f > 10.0) {
                new AlertDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.NumberFormatError"), Messages.getString("PlanetaryConditionsDialog.EnterValidGravity")).setVisible(true);
                return;
            }
            int n2 = this.choWind.getSelectedIndex();
            int n3 = this.choAtmosphere.getSelectedIndex();
            if (n3 == 0 && n2 > 0) {
                new AlertDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.Incompatible"), Messages.getString("PlanetaryConditionsDialog.VacuumWind")).setVisible(true);
                return;
            }
            if (n3 == 1 && n2 > 4) {
                new AlertDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.Incompatible"), Messages.getString("PlanetaryConditionsDialog.TraceWind")).setVisible(true);
                return;
            }
            if (n3 == 2 && n2 > 5) {
                new AlertDialog(this.client.frame, Messages.getString("PlanetaryConditionsDialog.Incompatible"), Messages.getString("PlanetaryConditionsDialog.ThinWind")).setVisible(true);
                return;
            }
            if (this.client != null) {
                this.send();
            }
        } else if (actionEvent.getSource() == this.butCancel) {
            this.refreshConditions();
        }
        this.setVisible(false);
    }
}

