/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.event.MechDisplayEvent;
import megamek.client.event.MechDisplayListener;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.FiringDisplay;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.HeatEffects;
import megamek.client.ui.AWT.Slider;
import megamek.client.ui.AWT.TargetingPhaseDisplay;
import megamek.client.ui.AWT.widget.AeroMapSet;
import megamek.client.ui.AWT.widget.ArmlessMechMapSet;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.BattleArmorMapSet;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.client.ui.AWT.widget.CapitalFighterMapSet;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.GeneralInfoMapSet;
import megamek.client.ui.AWT.widget.GunEmplacementMapSet;
import megamek.client.ui.AWT.widget.InfantryMapSet;
import megamek.client.ui.AWT.widget.JumpshipMapSet;
import megamek.client.ui.AWT.widget.LargeSupportTankMapSet;
import megamek.client.ui.AWT.widget.MechMapSet;
import megamek.client.ui.AWT.widget.MechPanelTabStrip;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PicMap;
import megamek.client.ui.AWT.widget.ProtomechMapSet;
import megamek.client.ui.AWT.widget.QuadMapSet;
import megamek.client.ui.AWT.widget.SpheroidMapSet;
import megamek.client.ui.AWT.widget.SquadronMapSet;
import megamek.client.ui.AWT.widget.TankMapSet;
import megamek.client.ui.AWT.widget.TransparentLabel;
import megamek.client.ui.AWT.widget.VTOLMapSet;
import megamek.client.ui.AWT.widget.WarshipMapSet;
import megamek.client.ui.Messages;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.ArmlessMech;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.LargeSupportTank;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Sensor;
import megamek.common.SmallCraft;
import megamek.common.Tank;
import megamek.common.VTOL;
import megamek.common.Warship;
import megamek.common.WeaponType;
import megamek.common.weapons.ACWeapon;
import megamek.common.weapons.BayWeapon;
import megamek.common.weapons.GaussWeapon;
import megamek.common.weapons.RACWeapon;
import megamek.common.weapons.UACWeapon;

public class MechDisplay
extends BufferedPanel {
    private static final long serialVersionUID = -4645698758006581017L;
    MechPanelTabStrip tabStrip;
    public BufferedPanel displayP;
    public MovementPanel mPan;
    public ArmorPanel aPan;
    public WeaponPanel wPan;
    public SystemPanel sPan;
    public ExtraPanel ePan;
    private ClientGUI clientgui;
    private Entity currentlyDisplaying = null;
    private Vector<MechDisplayListener> eventListeners = new Vector();

    public MechDisplay(ClientGUI clientGUI) {
        super(new GridBagLayout());
        this.clientgui = clientGUI;
        this.tabStrip = new MechPanelTabStrip(this);
        this.displayP = new BufferedPanel(new CardLayout());
        this.mPan = new MovementPanel();
        this.displayP.add("movement", this.mPan);
        this.aPan = new ArmorPanel();
        this.displayP.add("armor", this.aPan);
        this.wPan = new WeaponPanel(clientGUI, this);
        this.displayP.add("weapons", this.wPan);
        this.sPan = new SystemPanel(clientGUI);
        this.displayP.add("systems", this.sPan);
        this.ePan = new ExtraPanel(clientGUI);
        this.displayP.add("extras", this.ePan);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 1, 0, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.tabStrip, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.displayP, gridBagConstraints);
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, "movement");
        clientGUI.mechW.addKeyListener(clientGUI.menuBar);
    }

    public void addBag(Component component, GridBagConstraints gridBagConstraints) {
        ((GridBagLayout)this.getLayout()).setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void displayEntity(Entity entity) {
        this.clientgui.mechW.setTitle(entity.getShortName());
        this.currentlyDisplaying = entity;
        this.mPan.displayMech(entity);
        this.aPan.displayMech(entity);
        this.wPan.displayMech(entity);
        this.sPan.displayMech(entity);
        this.ePan.displayMech(entity);
    }

    public Entity getCurrentEntity() {
        return this.currentlyDisplaying;
    }

    public void showPanel(String string) {
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, string);
        if (string == "movement") {
            this.tabStrip.setTab(0);
        } else if (string == "armor") {
            this.tabStrip.setTab(1);
        } else if (string == "weapons") {
            this.tabStrip.setTab(3);
        } else if (string == "systems") {
            this.tabStrip.setTab(2);
        } else if (string == "extras") {
            this.tabStrip.setTab(4);
        }
    }

    public void addMechDisplayListener(MechDisplayListener mechDisplayListener) {
        this.eventListeners.addElement(mechDisplayListener);
    }

    public void removeMechDisplayListener(MechDisplayListener mechDisplayListener) {
        this.eventListeners.removeElement(mechDisplayListener);
    }

    public void processMechDisplayEvent(MechDisplayEvent mechDisplayEvent) {
        block3: for (int i = 0; i < this.eventListeners.size(); ++i) {
            MechDisplayListener mechDisplayListener = this.eventListeners.elementAt(i);
            switch (mechDisplayEvent.getType()) {
                case 0: {
                    mechDisplayListener.WeaponSelected(mechDisplayEvent);
                    continue block3;
                }
                default: {
                    System.err.println("unknown event " + mechDisplayEvent.getType() + " in processMechDisplayEvent");
                }
            }
        }
    }

    class ExtraPanel
    extends BufferedPanel
    implements ItemListener,
    ActionListener {
        private static final long serialVersionUID = -8727340674330120715L;
        private static final String IMAGE_DIR = "data/images/widgets";
        private TransparentLabel curSensorsL;
        private TransparentLabel narcLabel;
        private TransparentLabel unusedL;
        private TransparentLabel carrysL;
        private TransparentLabel heatL;
        private TransparentLabel sinksL;
        private TransparentLabel targSysL;
        public Choice chSensors;
        public TextArea unusedR;
        public TextArea carrysR;
        public TextArea heatR;
        public TextArea sinksR;
        public Button sinks2B;
        public List narcList;
        private int myMechId;
        private Slider prompt = null;
        private int sinks;
        private boolean dontChange;
        private final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayLargeFontSize"));

        public ExtraPanel(ClientGUI clientGUI) {
            FontMetrics fontMetrics = this.getFontMetrics(this.FONT_VALUE);
            this.curSensorsL = new TransparentLabel(Messages.getString("MechDisplay.CurrentSensors").concat(" "), fontMetrics, Color.white, 0);
            this.chSensors = new Choice();
            this.chSensors.addItemListener(this);
            this.narcLabel = new TransparentLabel(Messages.getString("MechDisplay.AffectedBy"), fontMetrics, Color.white, 0);
            this.narcList = new List(3, false);
            this.narcList.addKeyListener(clientGUI.menuBar);
            this.unusedL = new TransparentLabel(Messages.getString("MechDisplay.UnusedSpace"), fontMetrics, Color.white, 0);
            this.unusedR = new TextArea("", 2, 25, 1);
            this.unusedR.setEditable(false);
            this.unusedR.addKeyListener(clientGUI.menuBar);
            this.carrysL = new TransparentLabel(Messages.getString("MechDisplay.Carryng"), fontMetrics, Color.white, 0);
            this.carrysR = new TextArea("", 4, 25, 1);
            this.carrysR.setEditable(false);
            this.carrysR.addKeyListener(clientGUI.menuBar);
            this.sinksL = new TransparentLabel(Messages.getString("MechDisplay.activeSinksLabel"), fontMetrics, Color.white, 0);
            this.sinksR = new TextArea("", 2, 25, 1);
            this.sinksR.setEditable(false);
            this.sinksR.addKeyListener(clientGUI.menuBar);
            this.sinks2B = new Button(Messages.getString("MechDisplay.configureActiveSinksLabel"));
            this.sinks2B.setActionCommand("changeSinks");
            this.sinks2B.addActionListener(this);
            this.heatL = new TransparentLabel(Messages.getString("MechDisplay.HeatEffects"), fontMetrics, Color.white, 0);
            this.heatR = new TextArea("", 4, 25, 1);
            this.heatR.setEditable(false);
            this.heatR.addKeyListener(clientGUI.menuBar);
            this.targSysL = new TransparentLabel(Messages.getString("MechDisplay.TargSysLabel").concat(" "), fontMetrics, Color.white, 0);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagLayout = new GridBagLayout();
            gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.curSensorsL, gridBagConstraints);
            this.add(this.curSensorsL);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.chSensors, gridBagConstraints);
            this.add(this.chSensors);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.narcLabel, gridBagConstraints);
            this.add(this.narcLabel);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.narcList, gridBagConstraints);
            this.add(this.narcList);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.unusedL, gridBagConstraints);
            this.add(this.unusedL);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.unusedR, gridBagConstraints);
            this.add(this.unusedR);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.carrysL, gridBagConstraints);
            this.add(this.carrysL);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.carrysR, gridBagConstraints);
            this.add(this.carrysR);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.sinksL, gridBagConstraints);
            this.add(this.sinksL);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.sinksR, gridBagConstraints);
            this.add(this.sinksR);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.sinks2B, gridBagConstraints);
            this.add(this.sinks2B);
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.heatL, gridBagConstraints);
            this.add(this.heatL);
            gridBagConstraints.insets = new Insets(1, 9, 18, 9);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.heatR, gridBagConstraints);
            this.add(this.heatR);
            gridBagLayout.setConstraints(this.targSysL, gridBagConstraints);
            this.add(this.targSysL);
            this.setBackGround();
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void displayMech(Entity entity) {
            Object object;
            Serializable serializable;
            this.narcList.removeAll();
            this.sinks = 0;
            this.myMechId = entity.getId();
            if (MechDisplay.this.clientgui.getClient().getLocalPlayer().getId() != entity.getOwnerId()) {
                this.sinks2B.setEnabled(false);
                this.chSensors.setEnabled(false);
                this.dontChange = true;
            } else {
                this.sinks2B.setEnabled(true);
                this.chSensors.setEnabled(true);
                this.dontChange = false;
            }
            StringBuffer stringBuffer = null;
            Enumeration<Player> enumeration = ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPlayers();
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                int n = ((Player)serializable).getTeam();
                if (entity.isNarcedBy(n) && !((Player)serializable).isObserver()) {
                    stringBuffer = new StringBuffer(Messages.getString("MechDisplay.NARCedBy"));
                    stringBuffer.append(((Player)serializable).getName());
                    stringBuffer.append(" [").append(Player.teamNames[n]).append("]");
                    this.narcList.add(stringBuffer.toString());
                }
                if (!entity.isINarcedBy(n) || ((Player)serializable).isObserver()) continue;
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.INarcHoming"));
                stringBuffer.append(((Player)serializable).getName());
                stringBuffer.append(" [").append(Player.teamNames[n]).append("] ").append(Messages.getString("MechDisplay.attached")).append(".");
                this.narcList.add(stringBuffer.toString());
            }
            if (entity.isINarcedWith(2L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcECMPodAttached"));
                this.narcList.add(stringBuffer.toString());
            }
            if (entity.isINarcedWith(4L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcHaywirePodAttached"));
                this.narcList.add(stringBuffer.toString());
            }
            if (entity.isINarcedWith(8L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcNemesisPodAttached"));
                this.narcList.add(stringBuffer.toString());
            }
            if (entity.infernos.isStillBurning()) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.InfernoBurnRemaining"));
                stringBuffer.append(entity.infernos.getTurnsLeftToBurn());
                this.narcList.add(stringBuffer.toString());
            }
            if (entity instanceof Tank && ((Tank)entity).isOnFire()) {
                this.narcList.add(Messages.getString("MechDisplay.OnFire"));
            }
            if (entity.isSufferingEMI()) {
                this.narcList.add(Messages.getString("MechDisplay.IsEMId"));
            }
            if (Compute.isAffectedByECM(entity, (Coords)(serializable = entity.getPosition()), (Coords)serializable)) {
                this.narcList.add(Messages.getString("MechDisplay.InEnemyECMField"));
            } else if (Compute.isAffectedByAngelECM(entity, (Coords)serializable, (Coords)serializable)) {
                this.narcList.add(Messages.getString("MechDisplay.InEnemyAngelECMField"));
            }
            if (entity.isStealthActive()) {
                this.narcList.add(Messages.getString("MechDisplay.UnderStealth"));
            }
            if (entity instanceof BattleArmor && ((BattleArmor)entity).isBurdened()) {
                this.narcList.add(Messages.getString("MechDisplay.Burdened"));
            }
            if (entity.getTaserFeedBackRounds() > 0) {
                this.narcList.add(entity.getTaserFeedBackRounds() + " " + Messages.getString("MechDisplay.TaserFeedBack"));
            }
            if (entity.getTaserInterference() > 0) {
                this.narcList.add("+" + entity.getTaserInterference() + " " + Messages.getString("MechDisplay.TaserInterference"));
            }
            if (entity instanceof Tank && !((Tank)entity).hasNoTurret() && !entity.canChangeSecondaryFacing()) {
                this.narcList.add(Messages.getString("MechDisplay.Turretlocked"));
            }
            for (Mounted object22 : entity.getWeaponList()) {
                if (!object22.isJammed()) continue;
                stringBuffer = new StringBuffer(object22.getName());
                stringBuffer.append(Messages.getString("MechDisplay.isJammed"));
                this.narcList.add(stringBuffer.toString());
            }
            for (int i = 0; i < entity.locations(); ++i) {
                if (-1 != entity.getLocationStatus(i)) continue;
                stringBuffer = new StringBuffer(entity.getLocationName(i));
                stringBuffer.append(Messages.getString("MechDisplay.Breached"));
                this.narcList.add(stringBuffer.toString());
            }
            String string = entity.getUnusedString();
            if (string.equals("")) {
                string = Messages.getString("MechDisplay.None");
            }
            this.unusedR.setText(string);
            Enumeration<Entity> enumeration2 = entity.getLoadedUnits().elements();
            this.carrysR.setText(null);
            while (enumeration2.hasMoreElements()) {
                object = enumeration2.nextElement();
                if (((Entity)object).getRecoveryTurn() > 0) {
                    this.carrysR.append(((Entity)object).getShortName() + " (Recovery Turn " + Integer.toString(6 - ((Entity)object).getRecoveryTurn()) + ")");
                } else {
                    this.carrysR.append(((Entity)object).getShortName());
                }
                this.carrysR.append("\n");
            }
            for (Mounted bl : entity.getClubs()) {
                this.carrysR.append(bl.getName());
                this.carrysR.append("\n");
            }
            if (entity.hasSpotlight()) {
                if (entity.isUsingSpotlight()) {
                    this.carrysR.append(Messages.getString("MechDisplay.SearchlightOn"));
                } else {
                    this.carrysR.append(Messages.getString("MechDisplay.SearchlightOff"));
                }
            }
            this.heatR.setText("");
            this.sinksR.setText("");
            if (entity instanceof Mech) {
                object = (Mech)entity;
                this.sinks2B.setEnabled(!this.dontChange);
                this.sinks = ((Mech)object).getActiveSinksNextRound();
                if (((Mech)object).hasDoubleHeatSinks()) {
                    this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextDouble", new Object[]{new Integer(this.sinks), new Integer(this.sinks * 2)}));
                } else {
                    this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextSingle", new Object[]{new Integer(this.sinks)}));
                }
                boolean bl = false;
                boolean bl2 = false;
                if (((Mech)entity).hasTSM()) {
                    bl = true;
                }
                if (((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("tacops_heat")) {
                    bl2 = true;
                }
                this.heatR.append(HeatEffects.getHeatEffects(entity.heat, bl2, bl));
            } else {
                this.sinks2B.setEnabled(false);
            }
            this.refreshSensorChoices(entity);
            if (null != entity.getActiveSensor()) {
                this.curSensorsL.setText(Messages.getString("MechDisplay.CurrentSensors").concat(" ").concat(Sensor.getSensorName(entity.getActiveSensor().getType())));
            } else {
                this.curSensorsL.setText(Messages.getString("MechDisplay.CurrentSensors").concat(" None"));
            }
            this.targSysL.setText(Messages.getString("MechDisplay.TargSysLabel").concat(" ").concat(MiscType.getTargetSysName(entity.getTargSysType())));
        }

        private void refreshSensorChoices(Entity entity) {
            this.chSensors.removeAll();
            for (int i = 0; i < entity.getSensors().size(); ++i) {
                Sensor sensor = entity.getSensors().elementAt(i);
                String string = "";
                if (sensor.isBAP() && !entity.hasBAP(false)) {
                    string = " (Disabled)";
                }
                this.chSensors.add(Sensor.getSensorName(sensor.getType()) + string);
                if (sensor.getType() != entity.getNextSensor().getType()) continue;
                this.chSensors.select(i);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable() == this.chSensors) {
                Entity entity = ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId);
                entity.setNextSensor(entity.getSensors().elementAt(this.chSensors.getSelectedIndex()));
                this.refreshSensorChoices(entity);
                MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{"Active Sensors", Sensor.getSensorName(entity.getSensors().elementAt(this.chSensors.getSelectedIndex()).getType())}));
                MechDisplay.this.clientgui.getClient().sendUpdateEntity(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("changeSinks") && !this.dontChange) {
                this.prompt = new Slider(((MechDisplay)MechDisplay.this).clientgui.frame, Messages.getString("MechDisplay.changeSinks"), Messages.getString("MechDisplay.changeSinks"), this.sinks, 0, ((Mech)((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId)).getNumberOfSinks());
                if (!this.prompt.showDialog()) {
                    return;
                }
                ((MechDisplay)MechDisplay.this).clientgui.menuBar.actionPerformed(actionEvent);
                int n = this.prompt.getValue();
                ((Mech)((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId)).setActiveSinksNextRound(n);
                MechDisplay.this.clientgui.getClient().sendUpdateEntity(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
                this.displayMech(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
            }
        }
    }

    class SystemPanel
    extends BufferedPanel
    implements ItemListener,
    ActionListener {
        private static final long serialVersionUID = -1294456418186738773L;
        private static final String IMAGE_DIR = "data/images/widgets";
        private TransparentLabel locLabel;
        private TransparentLabel slotLabel;
        private TransparentLabel modeLabel;
        private TransparentLabel unitLabel;
        public List slotList;
        public List locList;
        public List unitList;
        public Choice m_chMode;
        public Button m_bDumpAmmo;
        private final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayLargeFontSize"));
        Entity en;
        Vector<Entity> entities = new Vector();

        public SystemPanel(ClientGUI clientGUI) {
            FontMetrics fontMetrics = this.getFontMetrics(this.FONT_VALUE);
            this.locLabel = new TransparentLabel(Messages.getString("MechDisplay.Location"), fontMetrics, Color.white, 0);
            this.slotLabel = new TransparentLabel(Messages.getString("MechDisplay.Slot"), fontMetrics, Color.white, 0);
            this.unitLabel = new TransparentLabel(Messages.getString("MechDisplay.Unit"), fontMetrics, Color.white, 0);
            this.locList = new List(8, false);
            this.locList.addItemListener(this);
            this.locList.addKeyListener(clientGUI.menuBar);
            this.slotList = new List(12, false);
            this.slotList.addItemListener(this);
            this.slotList.addKeyListener(clientGUI.menuBar);
            this.unitList = new List(8, false);
            this.unitList.addItemListener(this);
            this.unitList.addKeyListener(clientGUI.menuBar);
            this.m_chMode = new Choice();
            this.m_chMode.add("   ");
            this.m_chMode.setEnabled(false);
            this.m_chMode.addItemListener(this);
            this.m_chMode.addKeyListener(clientGUI.menuBar);
            this.m_bDumpAmmo = new Button(Messages.getString("MechDisplay.m_bDumpAmmo"));
            this.m_bDumpAmmo.setEnabled(false);
            this.m_bDumpAmmo.setActionCommand("dump");
            this.m_bDumpAmmo.addActionListener(this);
            this.m_bDumpAmmo.addKeyListener(clientGUI.menuBar);
            this.modeLabel = new TransparentLabel(Messages.getString("MechDisplay.modeLabel"), fontMetrics, Color.white, 1);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 1);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(this.locLabel, gridBagConstraints);
            this.add(this.locLabel);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(15, 1, 1, 9);
            gridBagLayout.setConstraints(this.slotLabel, gridBagConstraints);
            this.add(this.slotLabel);
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 1);
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(this.locList, gridBagConstraints);
            this.add(this.locList);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 1);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(this.unitLabel, gridBagConstraints);
            this.add(this.unitLabel);
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(1, 9, 15, 1);
            gridBagConstraints.gridheight = 0;
            gridBagLayout.setConstraints(this.unitList, gridBagConstraints);
            this.add(this.unitList);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagLayout.setConstraints(this.slotList, gridBagConstraints);
            this.add(this.slotList);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.modeLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.add(this.modeLabel);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagLayout.setConstraints(this.m_chMode, gridBagConstraints);
            this.add(this.m_chMode);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(4, 4, 15, 9);
            gridBagLayout.setConstraints(this.m_bDumpAmmo, gridBagConstraints);
            this.add(this.m_bDumpAmmo);
            this.setBackGround();
        }

        public int getSelectedLocation() {
            return this.locList.getSelectedIndex();
        }

        public CriticalSlot getSelectedCritical() {
            int n = this.locList.getSelectedIndex();
            int n2 = this.slotList.getSelectedIndex();
            if (n == -1 || n2 == -1) {
                return null;
            }
            return this.en.getCritical(n, n2);
        }

        public Mounted getSelectedEquipment() {
            CriticalSlot criticalSlot = this.getSelectedCritical();
            if (null == criticalSlot) {
                return null;
            }
            if (criticalSlot.getType() == 0) {
                return null;
            }
            return this.en.getEquipment(criticalSlot.getIndex());
        }

        private Entity getSelectedEntity() {
            int n = this.unitList.getSelectedIndex();
            if (n == -1 || n > this.entities.size()) {
                return null;
            }
            return this.entities.elementAt(n);
        }

        public void displayMech(Entity entity) {
            this.en = entity;
            this.entities.clear();
            this.entities.add(entity);
            this.unitList.removeAll();
            this.unitList.add(Messages.getString("MechDisplay.Ego"));
            for (Entity entity2 : entity.getLoadedUnits()) {
                this.unitList.add(entity2.getModel());
                this.entities.add(entity2);
            }
            this.unitList.select(0);
            this.displayLocations();
            this.displaySlots();
        }

        public void displayLocations() {
            this.locList.removeAll();
            for (int i = 0; i < this.en.locations(); ++i) {
                if (this.en.getNumberOfCriticals(i) <= 0) continue;
                this.locList.add(this.en.getLocationName(i), i);
            }
            this.locList.select(0);
        }

        private void displaySlots() {
            int n = this.locList.getSelectedIndex();
            this.slotList.removeAll();
            for (int i = 0; i < this.en.getNumberOfCriticals(n); ++i) {
                CriticalSlot criticalSlot = this.en.getCritical(n, i);
                StringBuffer stringBuffer = new StringBuffer(32);
                if (criticalSlot == null) {
                    stringBuffer.append("---");
                } else {
                    switch (criticalSlot.getType()) {
                        case 0: {
                            stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(criticalSlot.isBreached() ? "x" : "");
                            if (this.en instanceof Protomech) {
                                stringBuffer.append(Protomech.systemNames[criticalSlot.getIndex()]);
                                break;
                            }
                            stringBuffer.append(((Mech)this.en).getSystemName(criticalSlot.getIndex()));
                            break;
                        }
                        case 1: {
                            Mounted mounted = this.en.getEquipment(criticalSlot.getIndex());
                            stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(criticalSlot.isBreached() ? "x" : "").append(mounted.getDesc());
                            if (mounted.isHotLoaded()) {
                                stringBuffer.append(Messages.getString("MechDisplay.isHotLoaded"));
                            }
                            if (!mounted.getType().hasModes()) break;
                            stringBuffer.append(" (").append(mounted.curMode().getDisplayableName()).append(")");
                            if (!(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).isShield()) break;
                            stringBuffer.append(" " + mounted.getDamageAbsorption(this.en, n) + "/" + mounted.getCurrentDamageCapacity(this.en, n) + ")");
                        }
                    }
                }
                this.slotList.add(stringBuffer.toString());
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable() == this.unitList) {
                if (null != this.getSelectedEntity()) {
                    this.en = this.getSelectedEntity();
                    this.m_chMode.removeAll();
                    this.m_chMode.setEnabled(false);
                    this.displayLocations();
                    this.displaySlots();
                }
            } else if (itemEvent.getItemSelectable() == this.locList) {
                this.m_chMode.removeAll();
                this.m_chMode.setEnabled(false);
                this.displaySlots();
            } else if (itemEvent.getItemSelectable() == this.slotList) {
                boolean bl;
                this.m_bDumpAmmo.setEnabled(false);
                this.m_chMode.setEnabled(false);
                this.modeLabel.setEnabled(false);
                Mounted mounted = this.getSelectedEquipment();
                boolean bl2 = false;
                if (this.en instanceof Mech && (this.en.getExteriorUnitAt(1, true) != null || this.en.getExteriorUnitAt(3, true) != null || this.en.getExteriorUnitAt(2, true) != null)) {
                    bl2 = true;
                }
                boolean bl3 = bl = MechDisplay.this.clientgui.getClient().getLocalPlayer() == this.en.getOwner();
                if (mounted != null && bl && mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && IGame.Phase.PHASE_DEPLOYMENT != ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() && mounted.getShotsLeft() > 0 && !mounted.isDumping() && this.en.isActive() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().intOption("dumping_from_round") <= ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getRoundCount() && !bl2) {
                    this.m_bDumpAmmo.setEnabled(true);
                    if (((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("tacops_hotload") && this.en instanceof Tank && mounted.getType().hasFlag(8L)) {
                        this.m_bDumpAmmo.setEnabled(false);
                        this.modeLabel.setEnabled(true);
                        this.m_chMode.setEnabled(true);
                        this.m_chMode.removeAll();
                        Enumeration<EquipmentMode> enumeration = mounted.getType().getModes();
                        while (enumeration.hasMoreElements()) {
                            EquipmentMode equipmentMode = enumeration.nextElement();
                            this.m_chMode.add(equipmentMode.getDisplayableName());
                        }
                        this.m_chMode.select(mounted.curMode().getDisplayableName());
                    }
                } else if (mounted != null && bl && mounted.getType().hasModes()) {
                    if (!mounted.isDestroyed() && this.en.isActive()) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (!mounted.isDestroyed() && !this.en.isActive() && this.en.isCapitalFighter() && this.en.isPartOfFighterSquadron()) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (!mounted.isDestroyed() && mounted.getType().hasFlag(65536L)) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (mounted.getType().hasFlag(131072L) && ((WeaponType)mounted.getType()).getAmmoType() == -1 && !((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("tacops_energy_weapons")) {
                        this.m_chMode.removeAll();
                        return;
                    }
                    if (mounted.getType() instanceof GaussWeapon && !((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("tacops_gauss_weapons")) {
                        this.m_chMode.removeAll();
                        return;
                    }
                    if (this.en instanceof Aero && mounted.getType() instanceof ACWeapon || mounted.getType() instanceof RACWeapon || mounted.getType() instanceof UACWeapon) {
                        this.m_chMode.removeAll();
                        return;
                    }
                    this.modeLabel.setEnabled(true);
                    this.m_chMode.removeAll();
                    Enumeration<EquipmentMode> enumeration = mounted.getType().getModes();
                    while (enumeration.hasMoreElements()) {
                        EquipmentMode equipmentMode = enumeration.nextElement();
                        this.m_chMode.add(equipmentMode.getDisplayableName());
                    }
                    this.m_chMode.select(mounted.curMode().getDisplayableName());
                } else {
                    CriticalSlot criticalSlot = this.getSelectedCritical();
                    if (criticalSlot != null && criticalSlot.getType() == 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                        this.m_chMode.removeAll();
                        this.m_chMode.setEnabled(true);
                        this.m_chMode.add("EI Off");
                        this.m_chMode.add("EI On");
                        this.m_chMode.add("Aimed shot");
                        this.m_chMode.select(((Mech)this.en).getCockpitStatusNextRound());
                    }
                }
            } else if (itemEvent.getItemSelectable() == this.m_chMode) {
                int n;
                Mounted mounted = this.getSelectedEquipment();
                CriticalSlot criticalSlot = this.getSelectedCritical();
                if (mounted != null && mounted.getType().hasModes()) {
                    int n2 = this.m_chMode.getSelectedIndex();
                    if (n2 >= 0) {
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).isShield() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != IGame.Phase.PHASE_FIRING) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.ShieldModePhase", null));
                            return;
                        }
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).isVibroblade() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != IGame.Phase.PHASE_PHYSICAL) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.VibrobladeModePhase", null));
                            return;
                        }
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).hasSubType(0x800000L) && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != IGame.Phase.PHASE_MOVEMENT) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.RetractableBladeModePhase", null));
                            return;
                        }
                        if (mounted.getType() instanceof MiscType && mounted.getLinked() != null && ((MiscType)mounted.getType()).hasFlag(0x400000000L) && mounted.getLinked().isUsedThisRound() && n2 == 1) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.CapacitorCharging", null));
                            return;
                        }
                        mounted.setMode(n2);
                        MechDisplay.this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), n2);
                        if (mounted.canInstantSwitch(n2)) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{mounted.getName(), mounted.curMode().getDisplayableName()}));
                        } else if (IGame.Phase.PHASE_DEPLOYMENT == ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase()) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtStart", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                        } else {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                        }
                    }
                } else if (criticalSlot != null && criticalSlot.getType() == 0 && (n = this.m_chMode.getSelectedIndex()) >= 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                    Mech mech = (Mech)this.en;
                    mech.setCockpitStatus(n);
                    MechDisplay.this.clientgui.getClient().sendSystemModeChange(this.en.getId(), 2, n);
                    if (mech.getCockpitStatus() == mech.getCockpitStatusNextRound()) {
                        MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                    } else {
                        MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("dump")) {
                boolean bl;
                boolean bl2;
                Mounted mounted = this.getSelectedEquipment();
                boolean bl3 = bl2 = MechDisplay.this.clientgui.getClient().getLocalPlayer() == this.en.getOwner();
                if (mounted == null || !bl2 || !(mounted.getType() instanceof AmmoType) || mounted.getShotsLeft() <= 0) {
                    return;
                }
                boolean bl4 = false;
                if (mounted.isPendingDump()) {
                    bl = false;
                    String string = Messages.getString("MechDisplay.CancelDumping.title");
                    String string2 = Messages.getString("MechDisplay.CancelDumping.message", new Object[]{mounted.getName()});
                    bl4 = MechDisplay.this.clientgui.doYesNoDialog(string, string2);
                } else {
                    bl = true;
                    String string = Messages.getString("MechDisplay.Dump.title");
                    String string3 = Messages.getString("MechDisplay.Dump.message", new Object[]{mounted.getName()});
                    bl4 = MechDisplay.this.clientgui.doYesNoDialog(string, string3);
                }
                if (bl4) {
                    mounted.setPendingDump(bl);
                    MechDisplay.this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), bl ? -1 : 0);
                }
            }
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }
    }

    class WeaponPanel
    extends BufferedPanel
    implements ItemListener {
        private static final long serialVersionUID = -3872316514581547799L;
        private static final String IMAGE_DIR = "data/images/widgets";
        public List weaponList;
        public Choice m_chAmmo;
        public Choice m_chBayWeapon;
        public TransparentLabel wAmmo;
        public TransparentLabel wNameL;
        public TransparentLabel wHeatL;
        public TransparentLabel wArcHeatL;
        public TransparentLabel wDamL;
        public TransparentLabel wMinL;
        public TransparentLabel wShortL;
        public TransparentLabel wMedL;
        public TransparentLabel wLongL;
        public TransparentLabel wExtL;
        public TransparentLabel wAVL;
        public TransparentLabel wBayWeapon;
        public TransparentLabel wNameR;
        public TransparentLabel wHeatR;
        public TransparentLabel wArcHeatR;
        public TransparentLabel wDamR;
        public TransparentLabel wMinR;
        public TransparentLabel wShortR;
        public TransparentLabel wMedR;
        public TransparentLabel wLongR;
        public TransparentLabel wExtR;
        public TransparentLabel wShortAVR;
        public TransparentLabel wMedAVR;
        public TransparentLabel wLongAVR;
        public TransparentLabel wExtAVR;
        public TransparentLabel currentHeatBuildupL;
        public TransparentLabel currentHeatBuildupR;
        public TransparentLabel wTargetL;
        public TransparentLabel wRangeL;
        public TransparentLabel wToHitL;
        public TransparentLabel wTargetR;
        public TransparentLabel wRangeR;
        public TransparentLabel wToHitR;
        public TextArea toHitText;
        private Vector<Mounted> vAmmo;
        private Entity entity;
        private ClientGUI client;
        private MechDisplay owner;
        private final Font FONT_VALUE;

        public WeaponPanel(ClientGUI clientGUI, MechDisplay mechDisplay2) {
            super(new GridBagLayout());
            this.FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayMediumFontSize"));
            this.client = clientGUI;
            this.owner = mechDisplay2;
            FontMetrics fontMetrics = this.getFontMetrics(this.FONT_VALUE);
            Color color = Color.white;
            this.weaponList = new List(4, false);
            this.weaponList.addItemListener(this);
            this.weaponList.addKeyListener(clientGUI.menuBar);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 9);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.weaponList, gridBagConstraints);
            this.add(this.weaponList);
            this.wAmmo = new TransparentLabel(Messages.getString("MechDisplay.Ammo"), fontMetrics, color, -1);
            this.m_chAmmo = new Choice();
            this.m_chAmmo.addItemListener(this);
            this.m_chAmmo.addKeyListener(clientGUI.menuBar);
            this.wBayWeapon = new TransparentLabel(Messages.getString("MechDisplay.Weapon"), fontMetrics, color, -1);
            this.m_chBayWeapon = new Choice();
            this.m_chBayWeapon.addItemListener(this);
            this.m_chBayWeapon.addKeyListener(clientGUI.menuBar);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wBayWeapon, gridBagConstraints);
            this.add(this.wBayWeapon);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.m_chBayWeapon, gridBagConstraints);
            this.add(this.m_chBayWeapon);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wAmmo, gridBagConstraints);
            this.add(this.wAmmo);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.m_chAmmo, gridBagConstraints);
            this.add(this.m_chAmmo);
            this.currentHeatBuildupL = new TransparentLabel(Messages.getString("MechDisplay.HeatBuildup"), fontMetrics, color, 1);
            this.currentHeatBuildupR = new TransparentLabel("--", fontMetrics, color, -1);
            gridBagConstraints.insets = new Insets(2, 9, 2, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            ((GridBagLayout)this.getLayout()).setConstraints(this.currentHeatBuildupL, gridBagConstraints);
            this.add(this.currentHeatBuildupL);
            gridBagConstraints.insets = new Insets(2, 1, 2, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            ((GridBagLayout)this.getLayout()).setConstraints(this.currentHeatBuildupR, gridBagConstraints);
            this.add(this.currentHeatBuildupR);
            this.wNameL = new TransparentLabel(Messages.getString("MechDisplay.Name"), fontMetrics, color, 0);
            this.wHeatL = new TransparentLabel(Messages.getString("MechDisplay.Heat"), fontMetrics, color, 0);
            this.wArcHeatL = new TransparentLabel(Messages.getString("MechDisplay.ArcHeat"), fontMetrics, color, 0);
            this.wDamL = new TransparentLabel(Messages.getString("MechDisplay.Damage"), fontMetrics, color, 0);
            this.wNameR = new TransparentLabel("", fontMetrics, color, 0);
            this.wHeatR = new TransparentLabel("--", fontMetrics, color, 0);
            this.wArcHeatR = new TransparentLabel("--", fontMetrics, color, 0);
            this.wDamR = new TransparentLabel("--", fontMetrics, color, 0);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wNameL, gridBagConstraints);
            this.add(this.wNameL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wHeatL, gridBagConstraints);
            this.add(this.wHeatL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 3;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wDamL, gridBagConstraints);
            this.add(this.wDamL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 4;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wArcHeatL, gridBagConstraints);
            this.add(this.wArcHeatL);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wNameR, gridBagConstraints);
            this.add(this.wNameR);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wHeatR, gridBagConstraints);
            this.add(this.wHeatR);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 3;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wDamR, gridBagConstraints);
            this.add(this.wDamR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wArcHeatR, gridBagConstraints);
            this.add(this.wArcHeatR);
            this.wMinL = new TransparentLabel(Messages.getString("MechDisplay.Min"), fontMetrics, color, 0);
            this.wShortL = new TransparentLabel(Messages.getString("MechDisplay.Short"), fontMetrics, color, 0);
            this.wMedL = new TransparentLabel(Messages.getString("MechDisplay.Med"), fontMetrics, color, 0);
            this.wLongL = new TransparentLabel(Messages.getString("MechDisplay.Long"), fontMetrics, color, 0);
            this.wExtL = new TransparentLabel(Messages.getString("MechDisplay.Ext"), fontMetrics, color, 0);
            this.wAVL = new TransparentLabel(Messages.getString("MechDisplay.AV"), fontMetrics, color, 0);
            this.wMinR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wShortR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wMedR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wLongR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wExtR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wShortAVR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wMedAVR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wLongAVR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wExtAVR = new TransparentLabel("---", fontMetrics, color, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMinL, gridBagConstraints);
            this.add(this.wMinL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wShortL, gridBagConstraints);
            this.add(this.wShortL);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 6;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMedL, gridBagConstraints);
            this.add(this.wMedL);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 6;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wLongL, gridBagConstraints);
            this.add(this.wLongL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wExtL, gridBagConstraints);
            this.add(this.wExtL);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMinR, gridBagConstraints);
            this.add(this.wMinR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wShortR, gridBagConstraints);
            this.add(this.wShortR);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMedR, gridBagConstraints);
            this.add(this.wMedR);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 7;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wLongR, gridBagConstraints);
            this.add(this.wLongR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 7;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wExtR, gridBagConstraints);
            this.add(this.wExtR);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wAVL, gridBagConstraints);
            this.add(this.wAVL);
            gridBagConstraints.insets = new Insets(1, 1, 2, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wShortAVR, gridBagConstraints);
            this.add(this.wShortAVR);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMedAVR, gridBagConstraints);
            this.add(this.wMedAVR);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wLongAVR, gridBagConstraints);
            this.add(this.wLongAVR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wExtAVR, gridBagConstraints);
            this.add(this.wExtAVR);
            this.wTargetL = new TransparentLabel(Messages.getString("MechDisplay.Target"), fontMetrics, color, 0);
            this.wRangeL = new TransparentLabel(Messages.getString("MechDisplay.Range"), fontMetrics, color, 0);
            this.wToHitL = new TransparentLabel(Messages.getString("MechDisplay.ToHit"), fontMetrics, color, 0);
            this.wTargetR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wRangeR = new TransparentLabel("---", fontMetrics, color, 0);
            this.wToHitR = new TransparentLabel("---", fontMetrics, color, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wTargetL, gridBagConstraints);
            this.add(this.wTargetL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wTargetR, gridBagConstraints);
            this.add(this.wTargetR);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wRangeL, gridBagConstraints);
            this.add(this.wRangeL);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wRangeR, gridBagConstraints);
            this.add(this.wRangeR);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wToHitL, gridBagConstraints);
            this.add(this.wToHitL);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wToHitR, gridBagConstraints);
            this.add(this.wToHitR);
            this.toHitText = new TextArea("", 2, 20, 1);
            this.toHitText.setEditable(false);
            this.toHitText.addKeyListener(clientGUI.menuBar);
            gridBagConstraints.insets = new Insets(1, 9, 15, 9);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.toHitText, gridBagConstraints);
            this.add(this.toHitText);
            this.setBackGround();
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void displayMech(Entity entity) {
            CharSequence charSequence;
            Object object;
            int n;
            Object object3;
            IGame iGame = this.client.getClient().game;
            this.entity = entity;
            int n2 = entity.heat + entity.getEngineCritHeat() + Math.min(15, entity.heatFromExternal) + entity.heatBuildup;
            if (entity instanceof Mech) {
                if (entity.infernos.isStillBurning()) {
                    n2 += entity.infernos.getHeat();
                }
                if (!((Mech)entity).hasLaserHeatSinks()) {
                    n2 = iGame.getPlanetaryConditions().getTemperature() > 0 ? (n2 += iGame.getPlanetaryConditions().getTemperatureDifference(50, -30)) : (n2 -= iGame.getPlanetaryConditions().getTemperatureDifference(50, -30));
                }
            }
            Coords coords = this.entity.getPosition();
            if (!entity.isOffBoard() && coords != null) {
                object3 = iGame.getBoard().getHex(coords);
                if (object3.containsTerrain(19) && object3.getFireTurn() > 0) {
                    n2 += 5;
                }
                if (object3.terrainLevel(8) == 1) {
                    n2 += 5;
                } else if (object3.terrainLevel(8) == 2) {
                    n2 += 10;
                }
            }
            if (entity instanceof Mech && (entity.isStealthActive() || entity.isNullSigActive() || entity.isVoidSigActive())) {
                n2 += 10;
            }
            if (entity instanceof Mech && entity.isChameleonShieldActive()) {
                n2 += 6;
            }
            for (Mounted object22 : this.entity.getEquipment()) {
                n = 0;
                if (object22.hasChargedCapacitor()) {
                    n += 5;
                }
                if (n <= 0) continue;
                n2 += n;
            }
            this.weaponList.removeAll();
            this.m_chAmmo.removeAll();
            this.m_chAmmo.setEnabled(false);
            this.m_chBayWeapon.removeAll();
            this.m_chBayWeapon.setEnabled(false);
            object3 = new boolean[this.entity.locations()];
            boolean[] blArray = new boolean[this.entity.locations()];
            for (n = 0; n < this.entity.locations(); ++n) {
                object3[n] = false;
                blArray[n] = false;
            }
            for (n = 0; n < this.entity.getWeaponList().size(); ++n) {
                int n3;
                Mounted n6 = this.entity.getWeaponList().get(n);
                object = (WeaponType)n6.getType();
                charSequence = new StringBuffer(n6.getDesc());
                ((StringBuffer)charSequence).append(" [");
                ((StringBuffer)charSequence).append(entity.getLocationAbbr(n6.getLocation()));
                if (n6.isSplit()) {
                    ((StringBuffer)charSequence).append("/");
                    ((StringBuffer)charSequence).append(entity.getLocationAbbr(n6.getSecondLocation()));
                }
                ((StringBuffer)charSequence).append("]");
                if (((WeaponType)object).getAmmoType() != -1 && !((EquipmentType)object).hasFlag(16384L)) {
                    n3 = 0;
                    if (n6.getLinked() != null && !n6.getLinked().isDumping()) {
                        n3 = n6.getLinked().getShotsLeft();
                    }
                    EquipmentType n5 = null;
                    if (null != n6.getLinked()) {
                        n5 = n6.getLinked().getType();
                    }
                    int n4 = this.entity.getTotalMunitionsOfType(n5);
                    ((StringBuffer)charSequence).append(" (");
                    ((StringBuffer)charSequence).append(n3);
                    ((StringBuffer)charSequence).append("/");
                    ((StringBuffer)charSequence).append(n4);
                    ((StringBuffer)charSequence).append(")");
                }
                if (n6.isRapidfire()) {
                    ((StringBuffer)charSequence).append(Messages.getString("MechDisplay.rapidFire"));
                }
                if (n6.isHotLoaded()) {
                    ((StringBuffer)charSequence).append(Messages.getString("MechDisplay.isHotLoaded"));
                }
                if (((EquipmentType)object).hasModes()) {
                    ((StringBuffer)charSequence).append(" ");
                    ((StringBuffer)charSequence).append(n6.curMode().getDisplayableName());
                }
                this.weaponList.add(((StringBuffer)charSequence).toString());
                if (!n6.isUsedThisRound() || iGame.getPhase() != n6.usedInPhase() || iGame.getPhase() != IGame.Phase.PHASE_FIRING) continue;
                if (this.entity.usesWeaponBays()) {
                    if (iGame.getOptions().booleanOption("heat_by_bay")) {
                        for (int bl : n6.getBayWeapons()) {
                            n2 += this.entity.getEquipment(bl).getCurrentHeat();
                        }
                        continue;
                    }
                    n3 = n6.getLocation();
                    boolean bl = n6.isRearMounted();
                    if (!bl) {
                        if (object3[n3] != false) continue;
                        n2 += this.entity.getHeatInArc(n3, bl);
                        object3[n3] = true;
                        continue;
                    }
                    if (blArray[n3]) continue;
                    n2 += this.entity.getHeatInArc(n3, bl);
                    blArray[n3] = true;
                    continue;
                }
                if (n6.isBombMounted()) continue;
                n2 += n6.getCurrentHeat();
            }
            n = entity.getHeatCapacity();
            int n5 = entity.getHeatCapacityWithWater();
            object = Integer.toString(n);
            if (n < n5) {
                object = n + " [" + n5 + "]";
            }
            charSequence = Integer.toString(n2);
            if (n2 > entity.getHeatCapacityWithWater()) {
                charSequence = (String)charSequence + "*";
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.currentHeatBuildupR.setText((String)charSequence + " (" + (String)object + ")");
            if (this.entity.usesWeaponBays()) {
                this.wArcHeatL.setVisible(true);
                this.wArcHeatR.setVisible(true);
                this.m_chBayWeapon.setVisible(true);
                this.wBayWeapon.setVisible(true);
            } else {
                this.wArcHeatL.setVisible(false);
                this.wArcHeatR.setVisible(false);
                this.m_chBayWeapon.setVisible(false);
                this.wBayWeapon.setVisible(false);
            }
            if (this.entity instanceof Aero) {
                this.wAVL.setVisible(true);
                this.wShortAVR.setVisible(true);
                this.wMedAVR.setVisible(true);
                this.wLongAVR.setVisible(true);
                this.wExtAVR.setVisible(true);
                this.wMinL.setVisible(false);
                this.wMinR.setVisible(false);
            } else {
                this.wAVL.setVisible(false);
                this.wShortAVR.setVisible(false);
                this.wMedAVR.setVisible(false);
                this.wLongAVR.setVisible(false);
                this.wExtAVR.setVisible(false);
                this.wMinL.setVisible(true);
                this.wMinR.setVisible(true);
            }
            if (iGame.getOptions().booleanOption("tacops_range") || this.entity instanceof Aero) {
                this.wExtL.setVisible(true);
                this.wExtR.setVisible(true);
            } else {
                this.wExtL.setVisible(false);
                this.wExtR.setVisible(false);
            }
        }

        public void selectWeapon(int n) {
            if (n == -1) {
                this.weaponList.select(-1);
                return;
            }
            int n2 = this.entity.getWeaponList().indexOf(this.entity.getEquipment(n));
            this.weaponList.select(n2);
            this.displaySelected();
        }

        public int getSelectedWeaponNum() {
            int n = this.weaponList.getSelectedIndex();
            if (n == -1) {
                return -1;
            }
            return this.entity.getEquipmentNum(this.entity.getWeaponList().get(n));
        }

        private void displaySelected() {
            int n;
            Object object;
            if (this.weaponList.getSelectedIndex() == -1) {
                this.m_chAmmo.removeAll();
                this.m_chAmmo.setEnabled(false);
                this.m_chBayWeapon.removeAll();
                this.m_chBayWeapon.setEnabled(false);
                this.wNameR.setText("");
                this.wHeatR.setText("--");
                this.wArcHeatR.setText("---");
                this.wDamR.setText("--");
                this.wMinR.setText("---");
                this.wShortR.setText("---");
                this.wMedR.setText("---");
                this.wLongR.setText("---");
                this.wExtR.setText("---");
                return;
            }
            Mounted mounted = this.entity.getWeaponList().get(this.weaponList.getSelectedIndex());
            WeaponType weaponType = (WeaponType)mounted.getType();
            this.wNameR.setText(mounted.getDesc());
            if (mounted.hasChargedCapacitor()) {
                this.wHeatR.setText(Integer.toString(Compute.dialDownHeat(mounted, weaponType) + 5));
            } else if (weaponType.hasFlag(131072L) && weaponType.hasModes() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("tacops_energy_weapons")) {
                this.wHeatR.setText(Integer.toString(Compute.dialDownHeat(mounted, weaponType)));
            } else {
                this.wHeatR.setText(Integer.toString(mounted.getCurrentHeat()));
            }
            this.wArcHeatR.setText(Integer.toString(this.entity.getHeatInArc(mounted.getLocation(), mounted.isRearMounted())));
            if (weaponType.getDamage() == -2) {
                this.wDamR.setText(Messages.getString("MechDisplay.Missile"));
            } else if (weaponType.getDamage() == -3) {
                this.wDamR.setText(Messages.getString("MechDisplay.Variable"));
            } else if (weaponType.getDamage() == -4) {
                this.wDamR.setText(Messages.getString("MechDisplay.Special"));
            } else if (weaponType.getDamage() == -5) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Integer.toString(weaponType.getRackSize())).append('/').append(Integer.toString(weaponType.getRackSize() / 2));
                this.wDamR.setText(stringBuffer.toString());
            } else if (weaponType.hasFlag(131072L) && weaponType.hasModes() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("tacops_energy_weapons")) {
                if (mounted.hasChargedCapacitor()) {
                    this.wDamR.setText(Integer.toString(Compute.dialDownDamage(mounted, weaponType) + 5));
                } else {
                    this.wDamR.setText(Integer.toString(Compute.dialDownDamage(mounted, weaponType)));
                }
            } else {
                this.wDamR.setText(Integer.toString(weaponType.getDamage()));
            }
            int n2 = weaponType.getShortRange();
            int n3 = weaponType.getMediumRange();
            int n4 = weaponType.getLongRange();
            int n5 = weaponType.getExtremeRange();
            if (2 == this.entity.getLocationStatus(mounted.getLocation()) || n4 == 0) {
                n2 = weaponType.getWShortRange();
                n3 = weaponType.getWMediumRange();
                n4 = weaponType.getWLongRange();
                n5 = weaponType.getWExtremeRange();
            }
            if (weaponType.getMinimumRange() > 0) {
                this.wMinR.setText(Integer.toString(weaponType.getMinimumRange()));
            } else {
                this.wMinR.setText("---");
            }
            if (n2 > 1) {
                this.wShortR.setText("1 - " + n2);
            } else {
                this.wShortR.setText("" + n2);
            }
            if (n3 - n2 > 1) {
                this.wMedR.setText(n2 + 1 + " - " + n3);
            } else {
                this.wMedR.setText("" + n3);
            }
            if (n4 - n3 > 1) {
                this.wLongR.setText(n3 + 1 + " - " + n4);
            } else {
                this.wLongR.setText("" + n4);
            }
            if (n5 - n4 > 1) {
                this.wExtR.setText(n4 + 1 + " - " + n5);
            } else {
                this.wExtR.setText("" + n5);
            }
            if (null != mounted.getLinked()) {
                this.updateRangeDisplayForAmmo(mounted.getLinked());
            }
            if (this.entity instanceof Aero) {
                if (weaponType.isCapital()) {
                    this.wDamR.setText(Messages.getString("MechDisplay.CapitalD"));
                } else {
                    this.wDamR.setText(Messages.getString("MechDisplay.StandardD"));
                }
                if (weaponType instanceof BayWeapon) {
                    this.compileWeaponBay(mounted, weaponType.isCapital());
                } else {
                    this.updateAttackValues(weaponType, mounted.getLinked());
                }
            }
            int n6 = this.m_chBayWeapon.getSelectedIndex();
            this.m_chBayWeapon.removeAll();
            if (!(weaponType instanceof BayWeapon) || !this.entity.usesWeaponBays()) {
                this.m_chBayWeapon.setEnabled(false);
            } else {
                this.m_chBayWeapon.setEnabled(true);
                object = mounted.getBayWeapons().iterator();
                while (object.hasNext()) {
                    n = (Integer)object.next();
                    Mounted mounted2 = this.entity.getEquipment(n);
                    if (null == mounted2) continue;
                    this.m_chBayWeapon.add(this.formatBayWeapon(mounted2));
                }
                if (n6 == -1) {
                    this.m_chBayWeapon.select(0);
                } else {
                    this.m_chBayWeapon.select(n6);
                }
            }
            this.m_chAmmo.removeAll();
            object = mounted;
            if (weaponType instanceof BayWeapon) {
                n = this.m_chBayWeapon.getSelectedIndex();
                if (n == -1) {
                    n = 0;
                }
                mounted = this.entity.getEquipment(mounted.getBayWeapons().elementAt(n));
                weaponType = (WeaponType)mounted.getType();
            }
            if (weaponType.getAmmoType() == -1) {
                this.m_chAmmo.setEnabled(false);
            } else if (weaponType.hasFlag(16384L)) {
                if (mounted.getLinked().getShotsLeft() == 1) {
                    this.m_chAmmo.add(this.formatAmmo(mounted.getLinked()));
                    this.m_chAmmo.setEnabled(true);
                } else {
                    this.m_chAmmo.setEnabled(false);
                }
            } else {
                if (!(this.entity instanceof Infantry) || this.entity instanceof BattleArmor) {
                    this.m_chAmmo.setEnabled(true);
                } else {
                    this.m_chAmmo.setEnabled(false);
                }
                this.vAmmo = new Vector();
                n = -1;
                int n7 = 0;
                for (Mounted mounted3 : this.entity.getAmmo()) {
                    AmmoType ammoType = (AmmoType)mounted3.getType();
                    boolean bl = true;
                    if (this.entity instanceof SmallCraft || this.entity instanceof Jumpship) {
                        bl = mounted.getLocation() == mounted3.getLocation();
                    }
                    boolean bl2 = true;
                    if (this.entity.usesWeaponBays() && !(this.entity instanceof FighterSquadron)) {
                        bl2 = ((Mounted)object).ammoInBay(this.entity.getEquipmentNum(mounted3));
                    }
                    if (!mounted3.isAmmoUsable() || !bl || !bl2 || ammoType.getAmmoType() != weaponType.getAmmoType() || ammoType.getRackSize() != weaponType.getRackSize()) continue;
                    this.vAmmo.addElement(mounted3);
                    this.m_chAmmo.add(this.formatAmmo(mounted3));
                    if (mounted.getLinked() == mounted3) {
                        n = n7;
                    }
                    ++n7;
                }
                if (n != -1) {
                    this.m_chAmmo.select(n);
                }
            }
            this.owner.processMechDisplayEvent(new MechDisplayEvent(this, this.entity, mounted));
        }

        private String formatAmmo(Mounted mounted) {
            StringBuffer stringBuffer = new StringBuffer(64);
            int n = mounted.getDesc().indexOf(Messages.getString("MechDisplay.0"));
            int n2 = mounted.getLocation();
            if (n2 != -1) {
                stringBuffer.append("[").append(this.entity.getLocationAbbr(n2)).append("] ");
            }
            if (n == -1) {
                stringBuffer.append(mounted.getDesc());
            } else {
                stringBuffer.append(mounted.getDesc().substring(0, n));
                stringBuffer.append(mounted.getDesc().substring(n + 4));
            }
            return stringBuffer.toString();
        }

        private String formatBayWeapon(Mounted mounted) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(mounted.getDesc());
            return stringBuffer.toString();
        }

        private void updateRangeDisplayForAmmo(Mounted mounted) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (28 == ammoType.getAmmoType()) {
                if (ammoType.getMunitionType() == 128L) {
                    this.wMinR.setText("4");
                    this.wShortR.setText("1 - 9");
                    this.wMedR.setText("10 - 18");
                    this.wLongR.setText("19 - 27");
                    this.wExtR.setText("28 - 36");
                } else if (ammoType.getMunitionType() == 256L) {
                    this.wMinR.setText("---");
                    this.wShortR.setText("1 - 3");
                    this.wMedR.setText("4 - 6");
                    this.wLongR.setText("7 - 9");
                    this.wExtR.setText("10 - 12");
                } else {
                    this.wMinR.setText("4");
                    this.wShortR.setText("1 - 5");
                    this.wMedR.setText("6 - 10");
                    this.wLongR.setText("11 - 15");
                    this.wExtR.setText("16 - 20");
                }
            } else if (ammoType.getAmmoType() == 45) {
                if (ammoType.hasFlag(32L)) {
                    this.wMinR.setText("6");
                    this.wShortR.setText("1 - 7");
                    this.wMedR.setText("8 - 14");
                    this.wLongR.setText("15 - 21");
                    this.wExtR.setText("21 - 28");
                } else {
                    this.wMinR.setText("---");
                    this.wShortR.setText("1 - 3");
                    this.wMedR.setText("4 - 6");
                    this.wLongR.setText("7 - 9");
                    this.wExtR.setText("10 - 12");
                }
            }
            if (mounted.isHotLoaded()) {
                this.wMinR.setText("---");
            }
        }

        private void updateAttackValues(WeaponType weaponType, Mounted mounted) {
            int n = weaponType.getRoundShortAV();
            int n2 = weaponType.getRoundMedAV();
            int n3 = weaponType.getRoundLongAV();
            int n4 = weaponType.getRoundExtAV();
            int n5 = weaponType.getMaxRange();
            if (null != mounted) {
                AmmoType ammoType = (AmmoType)mounted.getType();
                double[] dArray = this.changeAttackValues(ammoType, n, n2, n3, n4, n5);
                n = (int)dArray[0];
                n2 = (int)dArray[1];
                n3 = (int)dArray[2];
                n4 = (int)dArray[3];
                n5 = (int)dArray[4];
            }
            this.wShortAVR.setText("---");
            this.wMedAVR.setText("---");
            this.wLongAVR.setText("---");
            this.wExtAVR.setText("---");
            this.wShortR.setText("---");
            this.wMedR.setText("---");
            this.wLongR.setText("---");
            this.wExtR.setText("---");
            this.wShortAVR.setText(Integer.toString(n));
            if (weaponType.isCapital()) {
                this.wShortR.setText("1-12");
            } else {
                this.wShortR.setText("1-6");
            }
            if (n5 > 1) {
                this.wMedAVR.setText(Integer.toString(n2));
                if (weaponType.isCapital()) {
                    this.wMedR.setText("13-24");
                } else {
                    this.wMedR.setText("7-12");
                }
            }
            if (n5 > 2) {
                this.wLongAVR.setText(Integer.toString(n3));
                if (weaponType.isCapital()) {
                    this.wLongR.setText("25-40");
                } else {
                    this.wLongR.setText("13-20");
                }
            }
            if (n5 > 3) {
                this.wExtAVR.setText(Integer.toString(n4));
                if (weaponType.isCapital()) {
                    this.wExtR.setText("41-50");
                } else {
                    this.wExtR.setText("21-25");
                }
            }
        }

        private double[] changeAttackValues(AmmoType ammoType, double d, double d2, double d3, double d4, int n) {
            int n2;
            if (28 == ammoType.getAmmoType()) {
                if (ammoType.getMunitionType() == 128L) {
                    n = 4;
                    d /= 2.0;
                    d3 = d2 /= 2.0;
                    d4 = d2;
                } else if (ammoType.getMunitionType() == 256L) {
                    n = 1;
                    d += d / 2.0;
                    d2 = 0.0;
                    d3 = 0.0;
                    d4 = 0.0;
                }
            } else if (ammoType.getAmmoType() == 45) {
                n2 = 0;
                if (ammoType.getMunitionType() == 8192L) {
                    int n3 = ammoType.getRackSize();
                    if (n3 == 5) {
                        ++n2;
                    } else if (n3 >= 7) {
                        n2 += 2;
                    }
                    d += (double)n2;
                    d2 += (double)n2;
                    d3 += (double)n2;
                }
                if (!ammoType.hasFlag(32L)) {
                    n = 1;
                    d *= 2.0;
                    d2 = 0.0;
                    d3 = 0.0;
                    d4 = 0.0;
                }
            } else if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9) {
                if (ammoType.getMunitionType() == 8192L) {
                    if (ammoType.getAmmoType() == 7) {
                        n2 = (int)Math.ceil((double)ammoType.getRackSize() / 5.0);
                        d += (double)n2;
                        d2 += (double)n2;
                        d3 += (double)n2;
                    }
                    if (ammoType.getAmmoType() == 9) {
                        d += 2.0;
                    }
                }
            } else if (ammoType.getAmmoType() == 19) {
                if (ammoType.getMunitionType() == 1L) {
                    n2 = (int)Math.floor(0.6 * (double)ammoType.getRackSize());
                    d = n2;
                    if (d2 > 0.0) {
                        d2 = n2;
                    }
                    if (d3 > 0.0) {
                        d3 = n2;
                    }
                    if (d4 > 0.0) {
                        d4 = n2;
                    }
                }
            } else if (ammoType.getAmmoType() == 61) {
                if (ammoType.hasFlag(128L)) {
                    d = 4.0;
                    d2 = 4.0;
                    d3 = 4.0;
                    d4 = 4.0;
                } else if (ammoType.hasFlag(64L)) {
                    d = 3.0;
                    d2 = 3.0;
                    d3 = 3.0;
                    d4 = 3.0;
                } else {
                    d = 2.0;
                    d2 = 2.0;
                    d3 = 2.0;
                    d4 = 2.0;
                }
                if (ammoType.hasFlag(512L)) {
                    d = 100.0;
                    d2 = 100.0;
                    d3 = 100.0;
                    d4 = 100.0;
                }
            }
            double[] dArray = new double[]{d, d2, d3, d4, n};
            return dArray;
        }

        private void compileWeaponBay(Mounted mounted, boolean bl) {
            Vector<Integer> vector = mounted.getBayWeapons();
            WeaponType weaponType = (WeaponType)mounted.getType();
            this.wShortAVR.setText("---");
            this.wMedAVR.setText("---");
            this.wLongAVR.setText("---");
            this.wExtAVR.setText("---");
            this.wShortR.setText("---");
            this.wMedR.setText("---");
            this.wLongR.setText("---");
            this.wExtR.setText("---");
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n2 = 1;
            for (int n3 : vector) {
                WeaponType weaponType2;
                Mounted mounted2 = this.entity.getEquipment(n3);
                if (mounted2.isBreached() || mounted2.isDestroyed() || mounted2.isJammed() || (weaponType2 = (WeaponType)mounted2.getType()).getAmmoType() != -1 && (mounted2.getLinked() == null || mounted2.getLinked().getShotsLeft() < 1)) continue;
                n += mounted2.getCurrentHeat();
                double d5 = weaponType2.getShortAV();
                double d6 = weaponType2.getMedAV();
                double d7 = weaponType2.getLongAV();
                double d8 = weaponType2.getExtAV();
                int n4 = weaponType2.getMaxRange();
                if (null != mounted2.getLinked()) {
                    double[] dArray = this.changeAttackValues((AmmoType)mounted2.getLinked().getType(), d5, d6, d7, d8, n4);
                    d5 = dArray[0];
                    d6 = dArray[1];
                    d7 = dArray[2];
                    d8 = dArray[3];
                    n4 = (int)dArray[4];
                }
                d += d5;
                d2 += d6;
                d3 += d7;
                d4 += d8;
                if (n4 <= n2) continue;
                n2 = n4;
            }
            double d9 = 1.0;
            if (weaponType.hasModes() && mounted.curMode().equals("Bracket 80%")) {
                d9 = 0.8;
            }
            if (weaponType.hasModes() && mounted.curMode().equals("Bracket 60%")) {
                d9 = 0.6;
            }
            if (weaponType.hasModes() && mounted.curMode().equals("Bracket 40%")) {
                d9 = 0.4;
            }
            d = d9 * d;
            d2 = d9 * d2;
            d3 = d9 * d3;
            d4 = d9 * d4;
            this.wHeatR.setText(Integer.toString(n));
            this.wShortAVR.setText(Integer.toString((int)Math.ceil(d)));
            if (bl) {
                this.wShortR.setText("1-12");
            } else {
                this.wShortR.setText("1-6");
            }
            if (n2 > 1) {
                this.wMedAVR.setText(Integer.toString((int)Math.ceil(d2)));
                if (bl) {
                    this.wMedR.setText("13-24");
                } else {
                    this.wMedR.setText("7-12");
                }
            }
            if (n2 > 2) {
                this.wLongAVR.setText(Integer.toString((int)Math.ceil(d3)));
                if (bl) {
                    this.wLongR.setText("25-40");
                } else {
                    this.wLongR.setText("13-20");
                }
            }
            if (n2 > 3) {
                this.wExtAVR.setText(Integer.toString((int)Math.ceil(d4)));
                if (bl) {
                    this.wExtR.setText("41-50");
                } else {
                    this.wExtR.setText("21-25");
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource().equals(this.weaponList)) {
                this.m_chBayWeapon.removeAll();
                this.displaySelected();
            } else if (itemEvent.getSource().equals(this.m_chAmmo)) {
                Mounted mounted;
                if (!MechDisplay.this.clientgui.getClient().getLocalPlayer().equals(this.entity.getOwner())) {
                    return;
                }
                int n = this.weaponList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                Mounted mounted2 = mounted = this.entity.getWeaponList().get(n);
                boolean bl = false;
                if (mounted.getType() instanceof BayWeapon) {
                    bl = true;
                    n = this.m_chBayWeapon.getSelectedIndex();
                    if (n == -1) {
                        return;
                    }
                    mounted = this.entity.getEquipment(mounted.getBayWeapons().elementAt(n));
                }
                Mounted mounted3 = mounted.getLinked();
                Mounted mounted4 = this.vAmmo.elementAt(this.m_chAmmo.getSelectedIndex());
                this.entity.loadWeapon(mounted, mounted4);
                if ((mounted3 == null || !mounted3.isHotLoaded()) && mounted4.isHotLoaded() || mounted3 != null && mounted3.isHotLoaded() && !mounted4.isHotLoaded()) {
                    this.displayMech(this.entity);
                    this.weaponList.select(n);
                    this.displaySelected();
                }
                this.updateRangeDisplayForAmmo(mounted4);
                if (this.entity instanceof Aero) {
                    WeaponType weaponType = (WeaponType)mounted.getType();
                    if (bl) {
                        this.compileWeaponBay(mounted2, weaponType.isCapital());
                    } else {
                        this.updateAttackValues(weaponType, mounted4);
                    }
                }
                if (this.client.curPanel instanceof FiringDisplay) {
                    ((FiringDisplay)this.client.curPanel).updateTarget();
                } else if (this.client.curPanel instanceof TargetingPhaseDisplay) {
                    ((TargetingPhaseDisplay)this.client.curPanel).updateTarget();
                }
                this.client.getClient().sendAmmoChange(this.entity.getId(), this.entity.getEquipmentNum(mounted), this.entity.getEquipmentNum(mounted4));
                this.displaySelected();
            } else if (itemEvent.getItemSelectable() == this.m_chBayWeapon) {
                int n = this.weaponList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                this.displaySelected();
            }
        }
    }

    class ArmorPanel
    extends PicMap {
        private static final long serialVersionUID = -3574160027530756521L;
        private TankMapSet tank;
        private MechMapSet mech;
        private InfantryMapSet infantry;
        private BattleArmorMapSet battleArmor;
        private ProtomechMapSet proto;
        private VTOLMapSet vtol;
        private QuadMapSet quad;
        private GunEmplacementMapSet gunEmplacement;
        private ArmlessMechMapSet armless;
        private LargeSupportTankMapSet largeSupportTank;
        private AeroMapSet aero;
        private CapitalFighterMapSet capFighter;
        private SquadronMapSet squad;
        private JumpshipMapSet jump;
        private SpheroidMapSet sphere;
        private WarshipMapSet warship;
        private int minTopMargin = 0;
        private int minLeftMargin = 0;
        private int minBottomMargin = 0;
        private int minRightMargin = 0;
        private static final int minTankTopMargin = 8;
        private static final int minTankLeftMargin = 8;
        private static final int minVTOLTopMargin = 8;
        private static final int minVTOLLeftMargin = 8;
        private static final int minMechTopMargin = 18;
        private static final int minMechLeftMargin = 7;
        private static final int minMechBottomMargin = 0;
        private static final int minMechRightMargin = 0;
        private static final int minInfTopMargin = 8;
        private static final int minInfLeftMargin = 8;
        private static final int minAeroTopMargin = 8;
        private static final int minAeroLeftMargin = 8;

        ArmorPanel() {
        }

        public void addNotify() {
            super.addNotify();
            this.tank = new TankMapSet(this);
            this.mech = new MechMapSet(this);
            this.infantry = new InfantryMapSet(this);
            this.battleArmor = new BattleArmorMapSet(this);
            this.proto = new ProtomechMapSet(this);
            this.vtol = new VTOLMapSet(this);
            this.quad = new QuadMapSet(this);
            this.gunEmplacement = new GunEmplacementMapSet(this);
            this.armless = new ArmlessMechMapSet(this);
            this.largeSupportTank = new LargeSupportTankMapSet(this);
            this.aero = new AeroMapSet(this);
            this.capFighter = new CapitalFighterMapSet(this);
            this.jump = new JumpshipMapSet(this);
            this.sphere = new SpheroidMapSet(this);
            this.warship = new WarshipMapSet(this);
            this.squad = new SquadronMapSet(this);
        }

        public void onResize() {
            Rectangle rectangle = this.getContentBounds();
            if (rectangle == null) {
                return;
            }
            int n = Math.round((this.getSize().width - rectangle.width) / 2);
            int n2 = Math.round((this.getSize().height - rectangle.height) / 2);
            int n3 = n < this.minLeftMargin ? this.minLeftMargin : n;
            int n4 = n2 < this.minTopMargin ? this.minTopMargin : n2;
            this.setContentMargins(n3, n4, this.minRightMargin, this.minBottomMargin);
        }

        public void displayMech(Entity entity) {
            Serializable serializable;
            if (null == entity) {
                return;
            }
            DisplayMapSet displayMapSet = this.mech;
            this.removeAll();
            if (entity instanceof QuadMech) {
                displayMapSet = this.quad;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof ArmlessMech) {
                displayMapSet = this.armless;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof Mech) {
                displayMapSet = this.mech;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof VTOL) {
                displayMapSet = this.vtol;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof LargeSupportTank) {
                displayMapSet = this.largeSupportTank;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Tank) {
                displayMapSet = this.tank;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof BattleArmor) {
                displayMapSet = this.battleArmor;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Infantry) {
                displayMapSet = this.infantry;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Protomech) {
                displayMapSet = this.proto;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof GunEmplacement) {
                displayMapSet = this.gunEmplacement;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Warship) {
                displayMapSet = this.warship;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Jumpship) {
                displayMapSet = this.jump;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof FighterSquadron) {
                displayMapSet = this.squad;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Aero) {
                displayMapSet = this.aero;
                if (entity instanceof SmallCraft && ((Aero)(serializable = (SmallCraft)entity)).isSpheroid()) {
                    displayMapSet = this.sphere;
                }
                if (entity.isCapitalFighter()) {
                    displayMapSet = this.capFighter;
                }
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            }
            if (null == displayMapSet) {
                System.err.println("The armor panel is null.");
                return;
            }
            displayMapSet.setEntity(entity);
            this.addElement(displayMapSet.getContentGroup());
            serializable = displayMapSet.getBackgroundDrawers();
            Enumeration<BackGroundDrawer> enumeration = ((Vector)serializable).elements();
            while (enumeration.hasMoreElements()) {
                this.addBgDrawer(enumeration.nextElement());
            }
            this.onResize();
            this.update();
        }
    }

    class MovementPanel
    extends PicMap {
        private static final long serialVersionUID = 4441873286085299525L;
        private GeneralInfoMapSet gi = new GeneralInfoMapSet(this);
        private int minTopMargin = 8;
        private int minLeftMargin = 8;

        public MovementPanel() {
            this.addElement(this.gi.getContentGroup());
            Vector<BackGroundDrawer> vector = this.gi.getBackgroundDrawers();
            Enumeration<BackGroundDrawer> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.addBgDrawer(enumeration.nextElement());
            }
            this.onResize();
        }

        public void addNotify() {
            super.addNotify();
            this.update();
        }

        public void onResize() {
            int n = this.getSize().width;
            Rectangle rectangle = this.getContentBounds();
            int n2 = Math.round((n - rectangle.width) / 2);
            if (n2 < this.minLeftMargin) {
                n2 = this.minLeftMargin;
            }
            int n3 = this.minTopMargin;
            this.setContentMargins(n2, n3, n2, n3);
        }

        public void displayMech(Entity entity) {
            this.gi.setEntity(entity);
            this.onResize();
            this.update();
        }
    }
}

