/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.texlipse.builder.OutputFileManager;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileTracking {
    private final IProject project;
    private final Set<IFolder> excludeFolders;
    private IFolder outputDir;
    private IFolder tempDir;
    private Set<IPath> tempDirNames;
    private Map<IPath, Long> buildDirNames;

    private static boolean hasMatchingExt(String name, String[] ext) {
        if (name != null) {
            String[] stringArray = ext;
            int n = ext.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (name.endsWith(e)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static String getMatchingExt(String name, String[] ext) {
        if (ext != null) {
            String[] stringArray = ext;
            int n = ext.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (name.endsWith(e)) {
                    return e;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean isProjectFile(String name) {
        if (name != null) {
            return ".project".equals(name) || ".texlipse".equals(name) || ProjectFileTracking.hasMatchingExt(name, new String[]{".tex", ".cls", ".sty", ".ltx"});
        }
        return false;
    }

    private static boolean isTempFile(String name, String[] ext, String format) {
        return ProjectFileTracking.hasMatchingExt(name, ext) || name.endsWith(".dvi") && !"dvi".equals(format) || name.endsWith(".ps") && !"ps".equals(format);
    }

    private boolean isNewer(IPath name, long currentTimestamp) {
        Long prevTimestamp = this.buildDirNames.get(name);
        return prevTimestamp == null || prevTimestamp < currentTimestamp;
    }

    private void recursiveScanFiles(IContainer container, Map<IPath, Long> nameMap, IProgressMonitor monitor) throws CoreException {
        IResource[] res;
        IResource[] iResourceArray = res = container.members();
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            IResource current = iResourceArray[n2];
            if (current instanceof IFolder && !this.excludeFolders.contains(current)) {
                IFolder subFolder = (IFolder)current;
                this.recursiveScanFiles((IContainer)subFolder, nameMap, monitor);
            } else if (!ProjectFileTracking.isProjectFile(current.getName())) {
                Long timestamp = new Long(current.getModificationStamp());
                nameMap.put(current.getProjectRelativePath(), timestamp);
            }
            monitor.worked(1);
            ++n2;
        }
    }

    public static Map<IPath, String> getOutputNames(IContainer aSourceContainer, String sourceBaseName, String[] derivedExts, String format, IProgressMonitor monitor) throws CoreException {
        HashMap<IPath, String> outputNames = new HashMap<IPath, String>();
        String dotFormat = String.valueOf('.') + format;
        String currentOutput = String.valueOf(sourceBaseName) + dotFormat;
        IResource[] iResourceArray = aSourceContainer.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile) {
                String name = res.getName();
                if (name.equals(currentOutput)) {
                    outputNames.put(res.getProjectRelativePath(), dotFormat);
                } else {
                    String ext = ProjectFileTracking.getMatchingExt(name, derivedExts);
                    if (ext != null && OutputFileManager.stripFileExt(name, ext).equals(sourceBaseName)) {
                        outputNames.put(res.getProjectRelativePath(), ext);
                    }
                }
            }
            monitor.worked(1);
            ++n2;
        }
        return outputNames;
    }

    public ProjectFileTracking(IProject project) {
        this.project = project;
        this.excludeFolders = new HashSet<IFolder>();
        this.init();
    }

    public void init() {
        this.excludeFolders.clear();
        this.tempDirNames = null;
        this.buildDirNames = null;
        this.outputDir = TexlipseProperties.getProjectOutputDir(this.project);
        this.tempDir = TexlipseProperties.getProjectTempDir(this.project);
        this.excludeFolders.add(this.outputDir);
        this.excludeFolders.add(this.tempDir);
    }

    public boolean isInitial() {
        return this.tempDirNames == null || this.buildDirNames == null;
    }

    public Set<IPath> getTempFiles() {
        return new HashSet<IPath>(this.tempDirNames);
    }

    public Set<IPath> getTempFolderNames(IProgressMonitor monitor) throws CoreException {
        HashMap<IPath, Long> tempDirFiles = new HashMap<IPath, Long>();
        if (this.tempDir != null && this.tempDir.exists()) {
            this.recursiveScanFiles((IContainer)this.tempDir, tempDirFiles, monitor);
        }
        return tempDirFiles.keySet();
    }

    public Set<IPath> getNewTempNames(IContainer container, String[] tempExts, String format, IProgressMonitor monitor) throws CoreException {
        HashSet<IPath> newNames = new HashSet<IPath>();
        HashMap<IPath, Long> currentNames = new HashMap<IPath, Long>();
        this.recursiveScanFiles(container, currentNames, monitor);
        for (Map.Entry names : currentNames.entrySet()) {
            IPath name = (IPath)names.getKey();
            Long timestamp = (Long)names.getValue();
            if (ProjectFileTracking.isTempFile(name.lastSegment(), tempExts, format) && this.isNewer(name, timestamp)) {
                newNames.add(name);
            }
            monitor.worked(1);
        }
        return newNames;
    }

    public void refreshSnapshots(IContainer container, IProgressMonitor monitor) throws CoreException {
        this.tempDirNames = this.getTempFolderNames(monitor);
        HashMap<IPath, Long> newBuildDirFiles = new HashMap<IPath, Long>();
        if (container != null && container.exists()) {
            this.recursiveScanFiles(container, newBuildDirFiles, monitor);
        }
        this.buildDirNames = newBuildDirFiles;
    }

    public void clearSnapshots() {
        this.tempDirNames = null;
        this.buildDirNames = null;
    }
}

