# Copyright (C) 1999 - Martin Strauss - under terms of GPL
proc NewFile {} {
 global FocusEditor
 global FilenameArray UpToDateArray
 global EDITORNUMMER
 global etcpath
 set E [EDITOR]
 $E.te.edit1 delete 1.0 end
 set FilenameArray($E) ""
 set UpToDateArray($E) 0
 wm title $E "no name $EDITORNUMMER"
 if [file exists "$etcpath/default.tex"] then {
  set f [open "$etcpath/default.tex" r]
  set x [read $f]
  $E.te.edit1 insert 1.0 $x
  set t [close $f]
 } else {
  $E.te.edit1 insert end "\\documentclass\[12pt,a4paper\]{report}\n"
#  $E.te.edit1 insert end "\\usepackage\[german\]{babel}\n"
#  $E.te.edit1 insert end "\\usepackage{umlaut}\n"
  $E.te.edit1 insert end "\\begin{document}\n\n"
  $E.te.edit1 insert end "\\end{document}\n"
 }
 Syntax $E.te.edit1 1.0 end
 set ksp [$E.te.edit1 search "\\begin{document}" 1.0]
 $E.te.edit1 mark set insert "$ksp + 1 lines"
 update
 event generate $E.te.edit1 <<Position_tail>> -when tail
# after 250 "event generate $E.te.edit1 <<Position_tail>> -when tail"
}
proc NewFileArg {} {
 global FocusEditor
 global FilenameArray UpToDateArray
 global EDITORNUMMER
 global etcpath
 set E [EDITOR]
 $E.te.edit1 delete 1.0 end
 set FilenameArray($E) ""
 set UpToDateArray($E) 0
 wm title $E "no name $EDITORNUMMER"
 if [file exists "$etcpath/default.tex"] then {
  set f [open "$etcpath/default.tex" r]
  set x [read $f]
  $E.te.edit1 insert 1.0 $x
  set t [close $f]
 } else {
  $E.te.edit1 insert end "\\documentclass\[12pt,a4paper\]{report}\n"
#  $E.te.edit1 insert end "\\usepackage\[german\]{babel}\n"
#  $E.te.edit1 insert end "\\usepackage{umlaut}\n"
  $E.te.edit1 insert end "\\begin{document}\n\n"
  $E.te.edit1 insert end "\\end{document}\n"
 }
 Syntax $E.te.edit1 1.0 end
 set ksp [$E.te.edit1 search "\\begin{document}" 1.0]
 $E.te.edit1 mark set insert "$ksp + 1 lines"
 update
 event generate $E.te.edit1 <<Position_tail>> -when tail
# after 250 "event generate $E.te.edit1 <<Position_tail>> -when tail"
}


proc LoadFile {} {
 global FilenameArray ModifiedArray directory
 set types {
    {{latex Files} {.tex} }
    {{plain Text} {.txt}}
    {{All Files}        *}
 }
 set filename [tk_getOpenFile -filetypes $types -initialdir $directory]
 LoadFileArg $filename 0
}

proc LoadFileArg {filename line} {
 global FilenameArray UpToDateArray ModifiedArray directory
 if {[file exists $filename]} then {
  set directory [file dirname $filename]
  set E [EDITOR]
  set f [open $filename r]
  set x [read $f]
  $E.te.edit1 insert 1.0 $x
  set t [close $f]
  #Set global filename
  set FilenameArray($E) $filename
  set UpToDateArray($E) [file mtime "$filename"]
  wm title $E "$filename"
  Syntax $E.te.edit1 1.0 end
  $E.te.edit1 mark set insert "1.0 + $line lines"
  event generate $E.te.edit1 <<Modified>>
  update
  event generate $E.te.edit1 <<Position_tail>> -when tail
  update
  focus $E.te.edit1
#  after 500 "event generate $E.te.edit1 <<Position_tail>> -when tail"
#  after 500 "focus $E.te.edit1"
 }
}
proc ReLoadFileArg {E filename} {
 global FilenameArray UpToDateArray ModifiedArray directory
 if {[file exists $filename]} then {
  set directory [file dirname $filename]
  set f [open $filename r]
  set x [read $f]
  set pos [$E.te.edit1 index insert]
  $E.te.edit1 delete 1.0 end 
  $E.te.edit1 insert 1.0 $x
  $E.te.edit1 mark set insert $pos
  set t [close $f]
  #Set global filename
  set FilenameArray($E) $filename
  set UpToDateArray($E) [file mtime "$filename"]
  Syntax $E.te.edit1 1.0 end
  focus $E.te.edit1
#  after 500 "event generate $E.te.edit1 <<Position_tail>> -when tail"
#  after 500 "focus $E.te.edit1"
 }
}

proc AppendFile {E} {
 global directory
 set types {
    {{latex Files} {.tex} }
    {{plain Text} {.txt}}
    {{All Files}        *}
 }
 set filename [tk_getOpenFile -filetypes $types -initialdir $directory]
 if {$filename != ""} then {
  set directory [file dirname $filename]
  set f [open $filename r]
  set x [read $f]
  #Append file at end of text
  $E.te.edit1 insert insert $x
  #Close source file
  set t [close $f]
  Syntax $E.te.edit1 1.0 end
  event generate $E.te.edit1 <<Modified>>
}}

proc UpToDateFile {E} {
 global FilenameArray UpToDateArray T
 if [file exists $FilenameArray($E)] {
  if { [file mtime $FilenameArray($E)] > $UpToDateArray($E) } {
   switch [tk_messageBox -parent $E -icon warning -message $T(FileUpToDate) -default yes -type yesno] yes {
    ReLoadFileArg $E $FilenameArray($E)
   } no {
     set UpToDateArray($E) [file mtime $FilenameArray($E)]
   }
  }
 }
}

proc SaveFile {E} {
 global FilenameArray UpToDateArray ModifiedArray
 if {$FilenameArray($E)!= ""} then {
  UpToDateFile $E
  if { ![file exists $FilenameArray($E)] || [file mtime $FilenameArray($E)] <= $UpToDateArray($E) } {
   set f [open $FilenameArray($E) w]
   #Get text to save
   set x [$E.te.edit1 get 1.0 end]
   #Save it
   puts $f $x
   #and close file
   set t [close $f]
   set ModifiedArray($E.te.edit1) 0
   set ModifiedArrayl($E.te.edit1) [string length $x]
   set UpToDateArray($E) [file mtime $FilenameArray($E)]
  }
 } else {SaveAsFile $E}
}

proc SaveAsFile {E} {
 global FilenameArray UpToDateArray ModifiedArray directory
 set types {
    {{latex Files} {.tex} }
    {{plain Text} {.txt}}
    {{All Files}        *}
 }
 set filename [tk_getSaveFile -filetypes $types -initialfile $FilenameArray($E) -defaultextension ".tex" -initialdir $directory]
 if {$filename != ""} then {
  set directory [file dirname $filename]
  set f [open $filename w]
  #Get text to save
  set x [$E.te.edit1 get 1.0 end]
  #Save it
  puts $f $x
  #and close file
  set t [close $f]
  set FilenameArray($E) $filename
  wm title $E "$FilenameArray($E)"
  set ModifiedArray($E.te.edit1) 0
  set UpToDateArray($E) [file mtime $FilenameArray($E)]
}}


