/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : stem.h
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/
#ifndef __STEM_H
#define __STEM_H

class istream;
class ostream;

#ifndef __FEATURE_H
#include "feature.h"
#endif

#ifndef __NOTE_H               // Stem
#include "note.h"
#endif

class SimpleNote;

/****************************************************************************
  class StemFeature
--*/

class StemFeature : public Feature {

protected:
    int beamNumber;
    NESTED_IN( Note )StemOrientation orientation;
    NESTED_IN( Note)Stem stem;

public:
    virtual void execute( SimpleNote& note );
    virtual void execute( StringList& parameters, Staff& staff );
    virtual void printOn( ostream& os ) const;

    StemFeature( const char* name, NESTED_IN( Note)Stem s, int parameterCount = 0 );
    StemFeature( const char* name, NESTED_IN( Note )Stem s, NESTED_IN( Note )StemOrientation o, int parameterCount = 0 );
    StemFeature( Staff& staff, SimpleNote& note );
    virtual ~StemFeature();
};
//-- class StemFeature //

/****************************************************************************
  class StyleFeature
--*/

class StyleFeature : public Feature {
    NESTED_IN( Note )Style style;
    
public:
    virtual void execute( SimpleNote& note );
    virtual void printOn( ostream& os ) const;

    StyleFeature( const char* name, NESTED_IN( Note )Style s );
    StyleFeature( Staff& staff, SimpleNote& note );
    virtual ~StyleFeature();
};
//-- class StyleFeature //

#endif // __STEM_H //
