/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXParserListener;

public enum DatumType {
    UNKNOWN(-1, "c_datatool_unknown_int", "unset"),
    STRING(0, "c_datatool_string_int", "string"),
    INTEGER(1, "c_datatool_integer_int", "int"),
    DECIMAL(2, "c_datatool_decimal_int", "real"),
    CURRENCY(3, "c_datatool_currency_int", "currency"),
    DATETIME(4, "c_datatool_datetime_int", "datetime"),
    DATE(5, "c_datatool_date_int", "date"),
    TIME(6, "c_datatool_time_int", "time");

    private final int id;
    private final String csname;
    private final String tag;

    private DatumType(int n2, String string2, String string3) {
        this.id = n2;
        this.csname = string2;
        this.tag = string3;
    }

    public int getValue() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public String getCsName() {
        return this.csname;
    }

    public ControlSequence getCs(TeXParserListener teXParserListener) {
        return teXParserListener.getControlSequence(this.csname);
    }

    public boolean isNumeric() {
        return this.id > 0;
    }

    public boolean isTemporal() {
        return this == DATETIME || this == DATE || this == TIME;
    }

    public static DatumType toDatumType(int n) {
        for (DatumType datumType : DatumType.values()) {
            if (datumType.id != n) continue;
            return datumType;
        }
        throw new IllegalArgumentException("Invalid DatumType id " + n);
    }

    public static DatumType toDatumType(String string) {
        if (string.equalsIgnoreCase("integer")) {
            return INTEGER;
        }
        if (string.equalsIgnoreCase("decimal")) {
            return DECIMAL;
        }
        for (DatumType datumType : DatumType.values()) {
            if (!datumType.tag.equalsIgnoreCase(string)) continue;
            return datumType;
        }
        throw new IllegalArgumentException("Invalid DatumType tag " + string);
    }

    @Deprecated
    public boolean overrides(DatumType datumType) {
        if (this == datumType) {
            return false;
        }
        if (this == UNKNOWN) {
            return false;
        }
        if (datumType == UNKNOWN) {
            return true;
        }
        if (this == STRING) {
            return true;
        }
        if (datumType == STRING) {
            return false;
        }
        if (this == CURRENCY) {
            return true;
        }
        if (datumType == CURRENCY) {
            return false;
        }
        if (this == DATETIME) {
            return true;
        }
        if (datumType == DATETIME) {
            return false;
        }
        return this == DECIMAL;
    }

    public static DatumType getDominant(DatumType datumType, DatumType datumType2) {
        if (datumType == datumType2) {
            return datumType;
        }
        if (datumType == UNKNOWN) {
            return datumType2;
        }
        if (datumType2 == UNKNOWN) {
            return datumType;
        }
        if (datumType == STRING || datumType2 == STRING) {
            return STRING;
        }
        if (datumType == CURRENCY || datumType2 == CURRENCY) {
            return CURRENCY;
        }
        if (datumType == DATETIME || datumType2 == DATETIME) {
            return DATETIME;
        }
        if (datumType == DATE && datumType2 == INTEGER || datumType2 == DATE && datumType == INTEGER) {
            return DATE;
        }
        if (datumType == DATE || datumType == TIME || datumType2 == DATE || datumType2 == TIME) {
            return DATETIME;
        }
        return datumType.id > datumType2.id ? datumType : datumType2;
    }
}

