/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import de.nm.ant.ipdf.AbstractPdfTask;
import de.nm.ant.ipdf.pages.PageRule;
import de.nm.ant.ipdf.range.PageRange;
import de.nm.ant.ipdf.types.Pages;
import de.nm.ant.ipdf.types.PdfFilePages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class PdfMergeTask
extends AbstractPdfTask {
    private final List<Pages> pdffiles = new ArrayList<Pages>();
    private ArrayList<PageRule> pdfliste;

    public void addPages(Pages set) {
        this.pdffiles.add(set);
    }

    public void addPdfFilePages(PdfFilePages set) {
        this.pdffiles.add(set);
    }

    private void createInsert() throws FileNotFoundException {
        this.pdfliste = new ArrayList();
        for (Pages fs : this.pdffiles) {
            PageRange pr;
            boolean empty = fs.isEmpty();
            File f = null;
            if (fs instanceof PdfFilePages) {
                PdfFilePages pfs = (PdfFilePages)fs;
                pr = new PageRange(pfs.getPages());
                f = pfs.getFile();
                if (f == null) {
                    throw new BuildException("pdffilepage: file must be set!");
                }
                if (!f.exists()) {
                    throw new FileNotFoundException(f.getAbsolutePath());
                }
            } else {
                pr = new PageRange();
            }
            PageRule pagerule = new PageRule(pr, f, empty);
            pagerule.setLandscape(fs.isLandscape());
            pagerule.setPagesize(fs.getPagesize());
            this.pdfliste.add(pagerule);
        }
    }

    public void execute() {
        try {
            File output = this.getOutputFile("pdf");
            this.logVerboseHeader(output);
            this.createInsert();
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, this.createOutputStream(output));
            copy.setPdfVersion(this.version);
            document.open();
            for (PageRule pr : this.pdfliste) {
                if (pr.isEmpty()) {
                    copy.addPage(this.createEmptyPage(pr.getPagesize(), pr.isLandscape()), 0);
                    continue;
                }
                File infile = pr.getPdffile();
                if (!infile.exists()) {
                    throw new BuildException("pdfmerge: file " + infile.getAbsolutePath() + " not found!");
                }
                PdfReader inreader = this.createPdfReaderFromFile(infile);
                PageRange pagerange = pr.getPagerange();
                int mp = inreader.getNumberOfPages();
                pagerange.setMaxPage(mp);
                for (int p = 1; p <= mp; ++p) {
                    if (!pagerange.isPageinRange(p)) continue;
                    if (this.verbose) {
                        this.log("merge: " + infile + "(" + p + ")", 2);
                    }
                    copy.addPage(copy.getImportedPage(inreader, p));
                }
            }
            document.close();
            copy.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }
}

