package ARM;

use RISCOS::SWI;
require Exporter;
use strict;
use vars qw (@ISA @EXPORT $VERSION $disassemble $mask);

@ISA = qw(Exporter);
@EXPORT = qw(disassemble);
$VERSION = 0.01;

$disassemble = SWINumberFromString("XDebugger_Disassemble");
$mask = &regmask([0..1],[1]);

sub disassemble ($;$)
{
    my ($inst, $addr) = @_;
    my ($result) = '1234';

    $addr += 0;	# force to be defined and numeric, default zero;
    
    return undef unless defined $inst;
    
    return undef unless swix ($disassemble, $mask, $inst, $addr, $result);
    
    return unpack 'p', $result;
}

$disassemble;	# Fail if we don't get the SWI
__END__

=head1 NAME

ARM --perl module to disassemble an arm instruction.

=head1 SYNOPSIS

    use Arm;
    $mnemonic = disassemble($instr, $addr_of_instr);

=head1 DESCRIPTION

This module provides a perl interface to C<Debugger_Dissassemble>, allowing
numeric ARM instructions to be disassembled to text mnemonics. It is necessary
to supply the address of the instruction to correctly disassemble C<PC> relative
instructions (I<i.e.> C<B>, C<BL>, C<LDR I<x>,[PC,#..]> - if this is omitted it
will default to zero.

Returns the textual mnemonic, or undefined on error.

=head1 BUGS

It is limited by the capabilities of the Debugger in the version of S<RISC OS>
it is running under. For example 32 bit ARM instructions will not be recognised
on an A series machine.

=head1 AUTHOR

Nicholas Clark <F<nick@unfortu.net>>

=cut
