/* -*-C-*-
*******************************************************************************
*
* File:         dpmi.h
* RCS:          $Header: $
* Description:  Simple DPMI interface
* Author:       Darryl Okahata
* Created:      Sun Mar 07 00:16:32 1993
* Modified:     Thu Oct 13 01:24:27 1994 (darrylo@home) darrylo@hostigos
* Language:     C
* Package:      N/A
* Status:       Experimental (Do Not Distribute)
*
* (C) Copyright 1993, Darryl Okahata, all rights reserved.
*
*******************************************************************************
*/

#ifndef __DPMI_H_INCLUDED
#define __DPMI_H_INCLUDED

#if defined(__WATCOMC__) && defined(__FLAT__)

# pragma pack(1);

# define DOS_EXTENDER

# define DPMI_INTERRUPT		0x31

# define DPMI_CARRY_FLAG	0x0001
# define DPMI_PARITY_FLAG	0x0004
# define DPMI_ZERO_FLAG		0x0040
# define DPMI_SIGN_FLAG		0x0080

typedef struct _dpmiregs {
    long	EDI;
    long	ESI;
    long	EBP;
    long	reserved;
    long	EBX;
    long	EDX;
    long	ECX;
    long	EAX;
    short	flags;
    short	ES;
    short	DS;
    short	FS;
    short	GS;
    short	IP;
    short	CS;
    short	SP;
    short	SS;
} DPMIREGS;


typedef struct _dpmiblock {
    short	segment;
    short	selector;
} DPMIBLOCK;


typedef struct _dpmi_meminfo {
    unsigned largest_avail_block;
    unsigned max_unlocked_page;
    unsigned largest_lockable_page;
    unsigned linear_addr_space;
    unsigned num_free_pages;
    unsigned num_physical_free_pages;
    unsigned total_physical_pages;
    unsigned free_linear_addr_space;
    unsigned pagefile_size;
    unsigned reserved[3];
} DPMI_MEMINFO;


extern int	dpmi_call_int(), dpmi_call_dos();
extern void	dpmi_get_meminfo();

# pragma pack();

#endif	/* __WATCOMC__ && __FLAT__ */

#endif	/* __DPMI_H_INCLUDED */
