/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.help.ui.internal.search;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.help.internal.base.*;
import org.eclipse.help.internal.search.*;
import org.eclipse.help.internal.workingset.*;
import org.eclipse.help.ui.internal.ide.*;
import org.eclipse.search.ui.*;
import org.eclipse.search.ui.text.*;
import org.eclipse.ui.*;
public class HelpSearchQuery implements org.eclipse.search.ui.ISearchQuery {
	private SearchQueryData queryData;
	private String singularLabel;
	private String pluralLabelpattern;
	private HelpSearchResult helpSearchResult;
	public HelpSearchQuery(SearchQueryData data) {
		super();
		queryData = data;
		singularLabel = HelpIdeResources.getString("singleSearchResult", //$NON-NLS-1$
				queryData.getSearchWord());
		pluralLabelpattern = HelpIdeResources.getString("multipleSearchResult", //$NON-NLS-1$
				queryData.getSearchWord(), "{0}"); //$NON-NLS-1$
	}
	public IStatus run(IProgressMonitor monitor) {
		try {
			WorkingSet[] workingSets = null; // no filtering
			if (queryData.isBookFiltering()) {
				IWorkingSet[] allWorkingSets = queryData
						.getSelectedWorkingSets();
				ArrayList helpWorkingSets = new ArrayList();
				WorkingSetManager wsmgr = BaseHelpSystem.getWorkingSetManager();
				for (int i = 0; i < allWorkingSets.length; i++) {
					WorkingSet ws = wsmgr.getWorkingSet(allWorkingSets[i]
							.getName());
					if (ws != null) {
						helpWorkingSets.add(ws);
					}
				}
				workingSets = (WorkingSet[]) helpWorkingSets
						.toArray(new WorkingSet[helpWorkingSets.size()]);
			}
			SearchResults results = new SearchResults(workingSets, queryData
					.getMaxHits(), queryData.getLocale());
			try {
				BaseHelpSystem.getSearchManager().search(
						queryData.getSearchQuery(), results, monitor);
			} catch (QueryTooComplexException qe) {
				// ignore
			}
			postResults(results);
		} catch (OperationCanceledException oce) {
			// allowed, no logging
			monitor.done();
			//throw oce;
		} catch (Exception e) {
			HelpIdePlugin.logError(HelpIdeResources.getString("WE021"), e); //$NON-NLS-1$
		}
		monitor.done();
		return new Status(IStatus.OK, HelpIdePlugin.PLUGIN_ID, 0, "", null); //$NON-NLS-1$
	}
	public String getLabel() {
		return HelpIdeResources.getString("Searching_for", queryData //$NON-NLS-1$
				.getSearchWord());
	}
	public boolean canRerun() {
		return true;
	}
	public boolean canRunInBackground() {
		return true;
	}
	public ISearchResult getSearchResult() {
		if (helpSearchResult == null) {
			helpSearchResult = new HelpSearchResult(this);
		}
		return helpSearchResult;
	}
	private void postResults(SearchResults results) {
		SearchHit[] searchHits = results.getSearchHits();
		// Filtering of results by activities
		ArrayList enabledHits = new ArrayList();
		for (int i = 0; i < searchHits.length; i++) {
			if (!queryData.isActivityFiltering()
					|| HelpBasePlugin.getActivitySupport().isEnabledTopic(
							searchHits[i].getHref(), queryData.getLocale())) {
				enabledHits.add(searchHits[i]);
			}
		}
		//
		Match[] matches = new Match[enabledHits.size()];
		for (int i = 0; i < enabledHits.size(); i++) {
			matches[i] = new Match(enabledHits.get(i), 0, 0);
		}
		((HelpSearchResult) getSearchResult()).removeAll(); // in case it is
		// rerun
		((HelpSearchResult) getSearchResult()).addMatches(matches);
	}
	/**
	 * @return Returns the pluralLabelpattern.
	 */
	String getPluralLabelpattern() {
		return pluralLabelpattern;
	}
	/**
	 * @return Returns the singularLabel.
	 */
	String getSingularLabel() {
		return singularLabel;
	}
	/**
	 * @return Returns the queryData.
	 */
	SearchQueryData getQueryData() {
		return queryData;
	}
}