/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIModificationVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDILocalVariable
extends JDIModificationVariable {
    private LocalVariable fLocal;
    private JDIStackFrame fStackFrame;

    public JDILocalVariable(JDIStackFrame frame, LocalVariable local) {
        super((JDIDebugTarget)frame.getDebugTarget());
        this.fStackFrame = frame;
        this.fLocal = local;
    }

    protected Value retrieveValue() throws DebugException {
        if (this.getStackFrame().isSuspended()) {
            return this.getStackFrame().getUnderlyingStackFrame().getValue(this.fLocal);
        }
        return this.getLastKnownValue();
    }

    public String getName() throws DebugException {
        try {
            return this.getLocal().name();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_retrieving_local_variable_name"), e.toString()), e);
            return null;
        }
    }

    protected void setValue(Value value) throws DebugException {
        try {
            this.getStackFrame().getUnderlyingStackFrame().setValue(this.getLocal(), value);
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_modifying_local_variable_value_1"), e.toString()), e);
        }
        catch (InvalidTypeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_modifying_local_variable_value_2"), e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_modifying_local_variable_value_3"), e.toString()), e);
        }
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            return this.getLocal().typeName();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_retrieving_local_variable_type_name"), e.toString()), e);
            return null;
        }
    }

    public String getSignature() throws DebugException {
        try {
            return this.getLocal().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_retrieving_local_variable_type_signature"), e.toString()), e);
            return null;
        }
    }

    protected void setLocal(LocalVariable local) {
        this.fLocal = local;
    }

    protected LocalVariable getLocal() {
        return this.fLocal;
    }

    protected JDIStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    public String toString() {
        return this.getLocal().toString();
    }

    public void setValue(IValue v) throws DebugException {
        if (this.verifyValue(v)) {
            JDIValue value = (JDIValue)v;
            try {
                this.getStackFrame().getUnderlyingStackFrame().setValue(this.getLocal(), value.getUnderlyingValue());
            }
            catch (InvalidTypeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_while_attempting_to_set_value_of_local_variable"), e.toString()), e);
            }
            catch (ClassNotLoadedException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_while_attempting_to_set_value_of_local_variable"), e.toString()), e);
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_while_attempting_to_set_value_of_local_variable"), e.toString()), e);
            }
        }
    }

    protected Type getUnderlyingType() throws DebugException {
        try {
            return this.getLocal().type();
        }
        catch (ClassNotLoadedException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_while_retrieving_type_of_local_variable"), e.toString()), e);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDILocalVariable.exception_while_retrieving_type_of_local_variable"), e.toString()), e);
        }
        return null;
    }

    public boolean isLocal() {
        return true;
    }
}

