/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.search.LRUWorkingSetsList;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.WorkingSetComparator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SearchUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "JavaElementSearchActions";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static IDialogSettings fgSettingsStore;
    private static final String BIN_PRIM_CONST_WARN_DIALOG_ID = "BinaryPrimitiveConstantWarningDialog";
    static /* synthetic */ Class class$java$lang$String;

    public static IJavaElement getJavaElement(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        try {
            IResource res;
            String handleId = (String)marker.getAttribute("org.eclipse.jdt.internal.ui.search.handleID");
            IJavaElement je = JavaCore.create((String)handleId);
            if (je == null) {
                return null;
            }
            if (!marker.getAttribute("org.eclipse.jdt.internal.ui.search.isWorkingCopy", false) && je.exists()) {
                return je;
            }
            ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
            if (cu == null) {
                return je;
            }
            if (!cu.exists() && (res = marker.getResource()) instanceof IFile && (cu = JavaCore.createCompilationUnitFrom((IFile)((IFile)res))) == null) {
                return je;
            }
            if (!je.exists()) {
                IJavaElement[] jElements = cu.findElements(je);
                je = jElements == null || jElements.length == 0 ? cu.getElementAt(marker.getAttribute("charStart", 0)) : jElements[0];
            }
            return je;
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.createJavaElement.title"), SearchMessages.getString("Search.Error.createJavaElement.message"));
            }
            return null;
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.createJavaElement.title"), SearchMessages.getString("Search.Error.createJavaElement.message"));
            return null;
        }
    }

    public static IJavaElement getJavaElement(Object entry) {
        if (entry != null && SearchUtil.isISearchResultViewEntry(entry)) {
            return SearchUtil.getJavaElement((ISearchResultViewEntry)entry);
        }
        return null;
    }

    public static IResource getResource(Object entry) {
        if (entry != null && SearchUtil.isISearchResultViewEntry(entry)) {
            return ((ISearchResultViewEntry)entry).getResource();
        }
        return null;
    }

    public static IJavaElement getJavaElement(ISearchResultViewEntry entry) {
        if (entry != null) {
            return SearchUtil.getJavaElement(entry.getSelectedMarker());
        }
        return null;
    }

    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    public static boolean isISearchResultViewEntry(Object object) {
        return object != null && SearchUtil.isSearchPlugInActivated() && object instanceof ISearchResultViewEntry;
    }

    static ICompilationUnit findCompilationUnit(IJavaElement element) {
        if (element == null) {
            return null;
        }
        return (ICompilationUnit)element.getAncestor(5);
    }

    public static IMember findInCompilationUnit(ICompilationUnit cu, IMember member) throws JavaModelException {
        if (member.getElementType() == 7) {
            return JavaModelUtil.findTypeInCompilationUnit(cu, JavaModelUtil.getTypeQualifiedName((IType)member));
        }
        IType declaringType = JavaModelUtil.findTypeInCompilationUnit(cu, JavaModelUtil.getTypeQualifiedName(member.getDeclaringType()));
        if (declaringType != null) {
            IInitializer result = null;
            switch (member.getElementType()) {
                case 8: {
                    result = declaringType.getField(member.getElementName());
                    break;
                }
                case 9: {
                    IMethod meth = (IMethod)member;
                    boolean isConstructor = meth.exists() ? meth.isConstructor() : declaringType.getElementName().equals(meth.getElementName());
                    result = JavaModelUtil.findMethod(meth.getElementName(), meth.getParameterTypes(), isConstructor, declaringType);
                    break;
                }
                case 10: {
                    result = declaringType.getInitializer(1);
                }
            }
            if (result != null && result.exists()) {
                return result;
            }
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) throws JavaModelException {
        if (element instanceof IMember) {
            return SearchUtil.findInCompilationUnit(cu, (IMember)element);
        }
        int type = element.getElementType();
        switch (type) {
            case 12: {
                return cu.getImportContainer();
            }
            case 11: {
                return SearchUtil.find((IJavaElement[])cu.getPackageDeclarations(), element.getElementName());
            }
            case 13: {
                return SearchUtil.find((IJavaElement[])cu.getImports(), element.getElementName());
            }
            case 5: {
                return cu;
            }
        }
        return null;
    }

    private static IJavaElement find(IJavaElement[] elements, String name) {
        if (elements == null || name == null) {
            return null;
        }
        for (int i = 0; i < elements.length; ++i) {
            if (!name.equals(elements[i].getElementName())) continue;
            return elements[i];
        }
        return null;
    }

    public static String toString(IWorkingSet[] workingSets) {
        Arrays.sort(workingSets, new WorkingSetComparator());
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            boolean firstFound = false;
            for (int i = 0; i < workingSets.length; ++i) {
                String workingSetName = workingSets[i].getName();
                if (firstFound) {
                    result = SearchMessages.getFormattedString("SearchUtil.workingSetConcatenation", new String[]{result, workingSetName});
                    continue;
                }
                result = workingSetName;
                firstFound = true;
            }
        }
        return result;
    }

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(workingSets);
        SearchUtil.saveState();
    }

    private static void saveState() {
        Iterator iter = fgLRUWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            String[] names = new String[workingSets.length];
            for (int j = 0; j < workingSets.length; ++j) {
                names[j] = workingSets[j].getName();
            }
            fgSettingsStore.put(STORE_LRU_WORKING_SET_NAMES + i, names);
            ++i;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        for (int i = LRU_WORKINGSET_LIST_SIZE - 1; i >= 0; --i) {
            String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES + i);
            if (lruWorkingSetNames == null) continue;
            HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(2);
            for (int j = 0; j < lruWorkingSetNames.length; ++j) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[j]);
                if (workingSet == null) continue;
                workingSets.add(workingSet);
            }
            foundLRU = true;
            if (workingSets.isEmpty()) continue;
            fgLRUWorkingSets.add(workingSets.toArray(new IWorkingSet[workingSets.size()]));
        }
        if (!foundLRU) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(LRU_WORKINGSET_LIST_SIZE);
        fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (fgSettingsStore == null) {
            fgSettingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        boolean foundLRU = false;
        String[] lruWorkingSetNames = fgSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (lruWorkingSetNames != null) {
            for (int i = lruWorkingSetNames.length - 1; i >= 0; --i) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[i]);
                if (workingSet == null) continue;
                foundLRU = true;
                fgLRUWorkingSets.add(new IWorkingSet[]{workingSet});
            }
        }
        if (foundLRU) {
            SearchUtil.saveState();
        }
    }

    public static void warnIfBinaryConstant(IJavaElement element, Shell shell) {
        if (SearchUtil.isBinaryPrimitveConstantOrString(element)) {
            OptionalMessageDialog.open(BIN_PRIM_CONST_WARN_DIALOG_ID, shell, SearchMessages.getString("Search.FindReferencesAction.BinPrimConstWarnDialog.title"), null, SearchMessages.getString("Search.FindReferencesAction.BinPrimConstWarnDialog.message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        }
    }

    private static boolean isBinaryPrimitveConstantOrString(IJavaElement element) {
        if (element != null && element.getElementType() == 8) {
            int flags;
            IField field = (IField)element;
            try {
                flags = field.getFlags();
            }
            catch (JavaModelException ex) {
                return false;
            }
            return field.isBinary() && Flags.isStatic((int)flags) && Flags.isFinal((int)flags) && SearchUtil.isPrimitiveOrString(field);
        }
        return false;
    }

    private static boolean isPrimitiveOrString(IField field) {
        String fieldType;
        try {
            fieldType = field.getTypeSignature();
        }
        catch (JavaModelException ex) {
            return false;
        }
        char first = fieldType.charAt(0);
        return first != 'L' && first != 'Q' && first != '[' || first == 'L' && fieldType.substring(1, fieldType.length() - 1).equals((class$java$lang$String == null ? (class$java$lang$String = SearchUtil.class$("java.lang.String")) : class$java$lang$String).getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

