/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.MatchFilter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class LevelTreeContentProvider
extends JavaSearchContentProvider
implements ITreeContentProvider {
    private Map fChildrenMap;
    private StandardJavaElementContentProvider fContentProvider;
    public static final int LEVEL_TYPE = 1;
    public static final int LEVEL_FILE = 2;
    public static final int LEVEL_PACKAGE = 3;
    public static final int LEVEL_PROJECT = 4;
    private static int[][] JAVA_ELEMENT_TYPES = new int[][]{{7}, {6, 5}, {4}, {2, 3}, {1}};
    private static int[][] RESOURCE_TYPES = new int[][]{new int[0], {1}, {2}, {4}, {8}};
    private static final int MAX_LEVEL = JAVA_ELEMENT_TYPES.length - 1;
    private int fCurrentLevel;

    public LevelTreeContentProvider(JavaSearchResultPage page, int level) {
        super(page);
        this.fCurrentLevel = level;
        this.fContentProvider = new FastJavaElementProvider();
    }

    public Object getParent(Object child) {
        Object possibleParent = this.internalGetParent(child);
        if (possibleParent instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)possibleParent;
            for (int j = this.fCurrentLevel; j < MAX_LEVEL + 1; ++j) {
                for (int i = 0; i < JAVA_ELEMENT_TYPES[j].length; ++i) {
                    if (javaElement.getElementType() != JAVA_ELEMENT_TYPES[j][i]) continue;
                    return null;
                }
            }
        } else if (possibleParent instanceof IResource) {
            IResource resource = (IResource)possibleParent;
            for (int j = this.fCurrentLevel; j < MAX_LEVEL + 1; ++j) {
                for (int i = 0; i < RESOURCE_TYPES[j].length; ++i) {
                    if (resource.getType() != RESOURCE_TYPES[j][i]) continue;
                    return null;
                }
            }
        }
        if (this.fCurrentLevel != 2 && child instanceof IType) {
            IType type = (IType)child;
            if (possibleParent instanceof ICompilationUnit || possibleParent instanceof IClassFile) {
                possibleParent = type.getPackageFragment();
            }
        }
        return possibleParent;
    }

    private Object internalGetParent(Object child) {
        return this.fContentProvider.getParent(child);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    protected synchronized void initialize(JavaSearchResult result) {
        super.initialize(result);
        this.fChildrenMap = new HashMap();
        if (result != null) {
            Object[] elements = result.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (this.getPage().getDisplayedMatchCount(elements[i]) <= 0) continue;
                this.insert(null, null, elements[i]);
            }
        }
    }

    protected void insert(Map toAdd, Set toUpdate, Object child) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (toAdd != null) {
                    this.insertInto(parent, child, toAdd);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this.fResult, child) && toAdd != null) {
            this.insertInto((Object)this.fResult, child, toAdd);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        return this.insertInto(parent, child, this.fChildrenMap);
    }

    private boolean insertInto(Object parent, Object child, Map map) {
        HashSet<Object> children = (HashSet<Object>)map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Set toRemove, Set toUpdate, Object element) {
        if (this.hasChildren(element)) {
            if (toUpdate != null) {
                toUpdate.add(element);
            }
        } else if (this.getPage().getDisplayedMatchCount(element) == 0) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                if (this.removeFromSiblings(element, parent)) {
                    this.remove(toRemove, toUpdate, parent);
                }
            } else if (this.removeFromSiblings(element, (Object)this.fResult) && toRemove != null) {
                toRemove.add(element);
            }
        } else if (toUpdate != null) {
            toUpdate.add(element);
        }
    }

    private boolean removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            return siblings.remove(element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public synchronized void elementsChanged(Object[] updatedElements) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getPage().getViewer();
        if (this.fResult == null) {
            return;
        }
        HashSet toRemove = new HashSet();
        HashSet toUpdate = new HashSet();
        HashMap toAdd = new HashMap();
        for (int i = 0; i < updatedElements.length; ++i) {
            if (this.getPage().getDisplayedMatchCount(updatedElements[i]) > 0) {
                this.insert(toAdd, toUpdate, updatedElements[i]);
                continue;
            }
            this.remove(toRemove, toUpdate, updatedElements[i]);
        }
        viewer.remove(toRemove.toArray());
        Iterator iter = toAdd.keySet().iterator();
        while (iter.hasNext()) {
            Object parent = iter.next();
            HashSet children = (HashSet)toAdd.get(parent);
            viewer.add(parent, children.toArray());
        }
        Iterator elementsToUpdate = toUpdate.iterator();
        while (elementsToUpdate.hasNext()) {
            viewer.refresh(elementsToUpdate.next());
        }
    }

    public void clear() {
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    public void setLevel(int level) {
        this.fCurrentLevel = level;
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    public void filtersChanged(MatchFilter[] filters) {
        super.filtersChanged(filters);
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    static class FastJavaElementProvider
    extends StandardJavaElementContentProvider {
        FastJavaElementProvider() {
        }

        public Object getParent(Object element) {
            return this.internalGetParent(element);
        }
    }
}

