/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateFileChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.jdt.internal.corext.util.IOCloser;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteFileChange
extends JDTChange {
    private IPath fPath;
    private String fSource;

    public DeleteFileChange(IFile file) {
        Assert.isNotNull(file, "file");
        this.fPath = file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) {
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(NLSChangesMessages.getString("deleteFile.deleting_resource"), 1);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Assert.isNotNull(file);
            Assert.isTrue(file.exists());
            Assert.isTrue(!file.isReadOnly());
            this.fSource = this.getSource(file);
            CreateFileChange undo = DeleteFileChange.createUndoChange(file, this.fPath, this.fSource);
            file.delete(true, true, pm);
            CreateFileChange createFileChange = undo;
            return createFileChange;
        }
        finally {
            pm.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSource(IFile file) throws CoreException {
        InputStream in = file.getContents();
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException ex) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            try {
                br = encoding != null ? new BufferedReader(new InputStreamReader(in, encoding)) : new BufferedReader(new InputStreamReader(in));
                int read = 0;
                while ((read = br.read()) != -1) {
                    sb.append((char)read);
                }
                Object var8_9 = null;
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                IOCloser.rethrows(br, in);
                throw throwable;
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
        }
        try {}
        catch (IOException e) {
            throw new JavaModelException((Throwable)e, 985);
        }
        IOCloser.rethrows(br, in);
        return sb.toString();
    }

    private static CreateFileChange createUndoChange(IFile file, IPath path, String source) {
        String encoding;
        try {
            encoding = file.getCharset(false);
        }
        catch (CoreException e) {
            encoding = null;
        }
        return new CreateFileChange(path, source, encoding);
    }

    public String getName() {
        return NLSChangesMessages.getString("deleteFile.Delete_File");
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }
}

