/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ICapabilityInstallWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.Category;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectCapabilitySimpleSelectionPage
extends WizardPage {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IProject project;
    private TreeViewer viewer;
    private CapabilityRegistry reg;
    private Capability chosenCapability;
    private HashMap mapCapToWizard = new HashMap();

    public ProjectCapabilitySimpleSelectionPage(String pageName, IWorkbench workbench, IStructuredSelection selection, IProject project) {
        super(pageName);
        this.workbench = workbench;
        this.selection = selection;
        this.project = project;
        this.reg = IDEWorkbenchPlugin.getDefault().getCapabilityRegistry();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topContainer = new Composite(parent, 0);
        topContainer.setLayout((Layout)new GridLayout());
        topContainer.setLayoutData((Object)new GridData(1808));
        Label label = new Label(topContainer, 16384);
        label.setText(IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.capabilities"));
        GridData data = new GridData();
        data.verticalAlignment = 128;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.viewer = new TreeViewer(topContainer, 2820);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.getTree().setFont(font);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setInput((Object)this.reg);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object result;
                IStructuredSelection sel;
                ProjectCapabilitySimpleSelectionPage.this.chosenCapability = null;
                if (event.getSelection() instanceof IStructuredSelection && (sel = (IStructuredSelection)event.getSelection()) != null && !sel.isEmpty() && (result = sel.getFirstElement()) instanceof Capability) {
                    ProjectCapabilitySimpleSelectionPage.this.chosenCapability = (Capability)((Object)result);
                }
                ProjectCapabilitySimpleSelectionPage.this.setPageComplete(ProjectCapabilitySimpleSelectionPage.this.validateChosenCapability());
            }
        });
        this.setControl((Control)topContainer);
    }

    private IContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof CapabilityRegistry) {
                    ArrayList cats = ProjectCapabilitySimpleSelectionPage.this.reg.getUsedCategories();
                    if (ProjectCapabilitySimpleSelectionPage.this.reg.getMiscCategory() != null) {
                        cats.add(ProjectCapabilitySimpleSelectionPage.this.reg.getMiscCategory());
                    }
                    return cats.toArray();
                }
                if (parentElement instanceof Category) {
                    return ((Category)((Object)parentElement)).getChildren(parentElement);
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof CapabilityRegistry) {
                    return true;
                }
                if (element instanceof Category) {
                    return ((Category)((Object)element)).hasElements();
                }
                return false;
            }
        };
    }

    public IWizardPage getNextPage() {
        if (this.chosenCapability == null) {
            return null;
        }
        final IWizard[] wizard = new IWizard[]{(IWizard)this.mapCapToWizard.get((Object)this.chosenCapability)};
        if (wizard[0] == null) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ICapabilityInstallWizard wiz = ProjectCapabilitySimpleSelectionPage.this.chosenCapability.getInstallWizard();
                    if (wiz != null) {
                        wiz.init(ProjectCapabilitySimpleSelectionPage.this.workbench, ProjectCapabilitySimpleSelectionPage.this.selection, ProjectCapabilitySimpleSelectionPage.this.project);
                        wiz.addPages();
                        ProjectCapabilitySimpleSelectionPage.this.mapCapToWizard.put(ProjectCapabilitySimpleSelectionPage.this.chosenCapability, wiz);
                        wizard[0] = wiz;
                    }
                }
            });
        }
        if (wizard[0] == null) {
            return null;
        }
        IWizardPage page = wizard[0].getStartingPage();
        wizard[0] = null;
        return page;
    }

    private boolean validateChosenCapability() {
        if (this.chosenCapability == null) {
            this.setErrorMessage(null);
            return false;
        }
        Capability[] caps = this.reg.getProjectCapabilities(this.project);
        List<Capability> existingCaps = Arrays.asList(caps);
        if (existingCaps.contains((Object)this.chosenCapability)) {
            this.setErrorMessage(IDEWorkbenchMessages.getString("ProjectCapabilitySimpleSelectionPage.capabilityExist"));
            return false;
        }
        String[] ids = this.reg.getPrerequisiteIds(this.chosenCapability);
        Capability[] prereqs = this.reg.findCapabilities(ids);
        for (int i = 0; i < prereqs.length; ++i) {
            if (prereqs[i] == null) {
                this.setErrorMessage(IDEWorkbenchMessages.format("ProjectCapabilitySimpleSelectionPage.capabilityMissing", new Object[]{ids[i]}));
                return false;
            }
            if (existingCaps.contains((Object)prereqs[i])) continue;
            this.setErrorMessage(IDEWorkbenchMessages.format("ProjectCapabilitySimpleSelectionPage.capabilityRequired", new Object[]{prereqs[i].getName()}));
            return false;
        }
        ids = this.reg.getMembershipSetIds(this.chosenCapability);
        List<String> idsList = Arrays.asList(ids);
        for (int i = 0; i < caps.length; ++i) {
            String[] setIds = this.reg.getMembershipSetIds(caps[i]);
            for (int j = 0; j < setIds.length; ++j) {
                if (!idsList.contains(setIds[j])) continue;
                this.setErrorMessage(IDEWorkbenchMessages.format("ProjectCapabilitySimpleSelectionPage.capabilitySet", new Object[]{caps[i].getName()}));
                return false;
            }
        }
        Capability[] newCaps = new Capability[caps.length + 1];
        System.arraycopy(caps, 0, newCaps, 0, caps.length);
        newCaps[caps.length] = this.chosenCapability;
        IStatus status = this.reg.validateCapabilities(newCaps);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

