/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.dialogs.InstallCapabilityStep;
import org.eclipse.ui.internal.ide.dialogs.MultiStepWizard;
import org.eclipse.ui.internal.ide.dialogs.ProjectPerspectiveChoiceDialog;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class MultiStepCapabilityWizard
extends MultiStepWizard
implements InstallCapabilityStep.IProjectProvider {
    protected MultiStepCapabilityWizard() {
    }

    protected abstract String[] getPerspectiveChoices();

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        if (this.isConfigureStepMode()) {
            IProject project;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            String[] perspIds = this.getPerspectiveChoices();
            if (perspIds.length > 0) {
                ProjectPerspectiveChoiceDialog dialog = new ProjectPerspectiveChoiceDialog(window, perspIds);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    window = dialog.showChosenPerspective();
                }
            }
            if ((project = this.getProject()) != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)project, window);
            }
        }
        return true;
    }
}

